---
title: "Viewing Change Logs"
order: 9
---

The Detailed Change Log lists an overview of updates, fixes, and new features, letting you know what has changed between Inedo Product releases. In this article we'll cover how to view these product changes using the Detailed Change Log.

## Using the Detailed Change Log to View Changes
The Detailed Change Log can be found on [MyInedo](https://my.inedo.com/) by navigating to "Downloads" > "Upgrade Guidance and Change Notes" and then selecting "Explore Detailed Change Logs".

![MyInedo](/resources/docs/myinedo-viewingchangelogs-myinedo.png){height="" width="50%"}

You can filter the change logs by count, product, and version to quickly locate changes in your product.

![Detailed Change Log Filters](/resources/docs/myinedo-viewingchangelogs-detailedchangelogfilters.png){height="" width="50%"}

### Identifying Types of Change
The Detailed Change Log lists changes by version (e.g., 2024.33) and ticket ID, detailing:
 * Bug Fixes
 * New Features
 * Performance Enhancement

### Upgrading Inedo Products
When [upgrading](/docs/installation/upgrading) any of your Inedo products to the latest version, we also recommend reading the upgrade notes, as they clearly break down the changes made in any release. We have written guides for each product, which includes recommended upgrade paths for major versions:
* [ProGet Upgrade Guide](/docs/proget-upgrade-guide)
* [BuildMaster Upgrade Guide](/docs/buildmaster-upgrading)
* [Otter Upgrade Guide](/docs/otter-upgrading)

## Using our Public Issue Tracker to View Details
Each update links to our [Public Issue Tracker](https://issues.inedo.com/dashboard?id=87c77108-8027-4453-aa65-15e83cf8782e&_gl=1*m68oqx*_gcl_au*NTUyMjMzOTM0LjE3NDE1ODEzMzM.) with more detailed information on the change.

![YouTrack](/resources/docs/myinedo-viewingchangelogs-youtrack.png){height="" width="50%"}

You can view the complete timeline of the issue, including when it started, when it was resolved, and the release version it was addressed. You can sldo see the issue's status. If the log shows the state as "completed", this lets you know the change has been implemented in the latest release.