---
title: "What is the Inedo Hub?"
order: 1
---

The Inedo Hub is used to install ProGet, BuildMaster, and Otter on Windows. It's a lightweight installer that acts as the one-stop shop for downloading, [installing](/docs/installation/windows/inedo-hub-installation-guide), [upgrading/downgrading](/docs/installation/windows/inedo-hub-upgrade-downgrade), and [maintaining your Inedo products](/docs/installation/windows/inedohub-configure-products). 

## Installing the Hub 

The Inedo Hub is itself a lightweight installable Windows app. It can be downloaded from [MyInedo](https://my.inedo.com/downloads) as a small executable file that downloads and installs the latest version of the hub when you execute it.

<iframe width="600" height="337" src="https://www.youtube.com/embed/yv7C-yrz1_E" frameborder="0" allowfullscreen="true"></iframe>


## Installation 

All products require an instance of SQL Server (any version of SQL Server currently supported by Microsoft may be used). The Hub can download and install a SQL Express instance – if this option is selected, an “Inedo” instance of SQL Express is installed (if the Inedo instance is already present on the local machine, that will be used and SQL Express will not be downloaded and installed again). If a connection string is supplied, the Hub must have permission to create and modify databases.

### Web Server

A web server is also required for all Inedo applications: the Hub can install products to use either an integrated web server or IIS. The integrated web server is a light weight, fully functional web server that supports both HTTP and HTTPS bindings.  It is best used when you are using a dedicated server for ProGet.  Although the integrated web server supports shared ports via host name bindings, it is best used when it can listen to all traffic on a specific port(s). If you plan to use a more complex setup like hosting multiple applications, using multiple bindings, request logging, IIS based load balancing ([NLB](/docs/installation/high-availability-load-balancing/installation-using-microsoft-nlb), ARR, etc..), or other IIS features, it is best to use IIS.  

If IIS is selected in the Hub but is not currently installed on the server, you will be prompted to install it. When installing using IIS hosting, the Hub creates an AppPool named [ProductName]AppPool and a Web Application called [ProductName].

### License Key

All products also require a [license key](/docs/myinedo/activating-a-license-key) from Inedo. You can request a trial or free license key through [MyInedo](/docs/myinedo/overview). You may also choose not to register at this time. If you install a product without registering, you will have to add the key within the software itself.

## Upgrades

You can upgrade products to any greater version number by clicking on the Upgrade button and selecting the desired version. By default, the latest stable version is selected, but you can choose a lower version or a later [prerelease version](/docs/installation/windows/desktophub-overview#prerelease){target="_blank"} as well.

Upgrades also required a connection string. By default, the connection string used by the application is used, but you may supply an alternative one to use for the upgrade instead (this is necessary if the software runs as a lower-privilege user not able to make schema changes and you are not using integrated authentication).

## Downgrades

Products can also be downgraded to any lower version by clicking on the Downgrade (or Upgrade) button and selecting the desired version. Functionally, this is the exact same operation as Upgrade, so refer to the Upgrades documentation for more information.

When considering upgrading or downgrading your Inedo products you can [View Upgrade Guidance](/docs/installation/upgrading#viewing-upgrade-guidance) on MyInedo, to view the recommended route to your intended product version.

## Uninstallation 

Individual products can be uninstalled by clicking on its associated Uninstall button. The uninstall operation stops and removes all services, IIS sites and app pools, and removes installed program files. Uninstallation does **not** remove any databases or data files such as packages, artifacts, or extensions.

## Uninstalling the Hub 

The Inedo Hub has no background services and only occupies a few megabytes of disk space - it is simply an app designed to make managing your Inedo product installations easier, so we recommend keeping it installed unless you are totally removing every product on a server and will no longer need it.

That said, The hub itself may be uninstalled by either using the Programs and Features dialog in Windows or executing the InedoHubUninstaller.exe program directly.

Uninstalling the hub will **not** uninstall all of the individual Inedo products automatically. If you want to uninstall everything, use the hub to uninstall each product first.

