---
title: "Connectors Management API"
order: 2
---

The Connectors Management API provides several pgutil commands (available as `pgutil connectors`) and HTTP endpoints to query, create, and update [connectors](/docs/proget/feeds/connector-overview), and related data:

## pgutil Commands

All HTTP endpoints of the Connectors Management API are available as `pgutil` commands. 

To find the list of commands available in `pgutil`, simply run `pgutil connectors`. See [Getting started with pgutil](/docs/proget/reference-api/proget-pgutil) to learn more.

## Available HTTP Endpoints

* [Create Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-create) - creates a specified connector
* [Get Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-get) - describes an specified connector
* [List Connectors](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-list) - describes all connectors, filtered as specified
* [Update Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-update) - updates a specified connector
* [Delete Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-delete) - deletes a specified connector

## Authenticating to Connectors Management API { #authentication }

The following is a summary of access types and their corresponding requirements for various API keys types and endpoints within this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Use/Manage Feeds`  
| Feed API Keys | `View/Download` is required for all endpoints<br/>`Add/Repackage` is required for [Create Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-create)<br/>`Overwrite/Delete` is required for [Delete Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-delete)
| Personal API Key | `Feeds_ViewFeed` is required for all endpoints<br/>`Feeds_AddPackage` is required for the [Create Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-create)<br/>`Feeds_DeletePackage` is required for [Delete Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-delete)
| No API Key | anonymous or authenticated user must have at least `Feeds_ViewFeed`

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/reference-api/proget-apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to the list connectors endpoint, you could specify the API key as follows:
````
curl -X GET --header "X-ApiKey: abc12345" "https://proget.corp.local/api/management/connectors/list"
````
:::

## Data Specifications  { #data-specifications }

### ProgetConnector Object Attributes  { #connector-object }
`ProgetConnector` is a JSON object (see [ProgetConnector.cs](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/ProGetConnector.cs)) that corresponds to the fields on a connector. It's used as input for [Create Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-create) and [Update Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-update), and output for [Get Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-get) and [List Connectors](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-list).

`name` and `feedType` properties are required for [Create Connector](/docs/proget/reference-api/feeds/proget-api-connectors/proget-api-connectors-create). Unless otherwise indicated, omitting a property or supplying `null` as the value will keep the current setting.

#### Example JSON Object:
```
{
  "name": "example-connector",
  "feedType": "nuget",
  "url": "http://proget.connector.local",
  "username": "jsmith",
  "password": "pass123",
  "timeout": 60,
  "filters": ["filter1", "filter2"],
  "metadataCacheEnabled": true,
  "metadataCacheMinutes": 30,
  "metadataCacheCount": 100
}
```

## Notes about Data

### Wildcards and Negations
Certain fields noted above support wildcard and negation syntax. For example, the value `["Microsoft.*", "Castle.*", "!Rubbishsoft.*"]` has the following properties:
 - includes any packages that start with `Microsoft.` or `Castle.*`
 - excludes any packages that start with `Rubbishsoft.`
