---
title: "Viewing Upgrade Guidance"
order: 8
---

Inedo products do not update themselves automatically, allowing you to avoid unexpected "surprises," but [there are times when upgrading your software version is recommended](/docs/installation/upgrading#when-should-i-upgrade-my-inedo-product), from UX improvements and system requirement changes to bug fixes and maintaining security. However, we know that the upgrade process can sometimes require extra consideration.

We provide support on how to best [update](/docs/installation/upgrading) your existing Inedo product versions when necessary, with clear upgrade guidance available on the MyInedo portal. This article will show you how to access Inedo's Upgrade Guidance and Change Notes to transition between software versions.

## Navigate to Upgrade Guidance & Change Notes

From the top of the main MyInedo page, select "Downloads," then "Upgrade Guidance and Change Notes."

![Upgrade Guidance and Change Notes](/resources/docs/myinedo-viewingupgradeguidance-upgradeguidanceandchangenotes.png){height="" width="50%"}

## Choose your Upgrade Version

In the upgrade guidance dialogue box select your Inedo product from the dropdown menu. Begin typing your currently installed software version and your chosen upgrade version to have the fields autofill. Select "Get Upgrade Guidance" to view the recommended upgrade path.

![Get Upgrade Guidance](/resources/docs/myinedo-viewingupgradeguidance-getupgradeguidance.png){height="" width="50%"}

From the Upgrade Guidance page, you can access the following:

* Recommended upgrade path
* Change logs
* Public Issue Tracker

### Recommended Upgrade Path

Here you can view information on our recommended route for upgrading to your desired software version, along with links to instructions on how to do so.

![Upgrade Path](/resources/docs/myinedo-viewingupgradeguidance-recommendationbox.png){height="" width="50%"}

### Change Logs

View our change logs for information on each version, helping you identify any key changes or fixes related to a specific release. Select an issue number to view detailed information on our [Public Issue Tracker](https://issues.inedo.com/dashboard?id=87c77108-8027-4453-aa65-15e83cf8782e) about the fixes or changes of that issue.

![Change Logs](/resources/docs/myinedo-viewingupgradeguidance-changelogs.png){height="" width="50%"}

## Upgrade Guidance

We provide several types of upgrade guidance depending on which versions of Inedo software you are upgrading to and from. A direct upgrade path is usually possible, however upgrades between more distant versions may require extra steps.

### Recommended Upgrade (Latest Release)

When upgrading from more recent versions (e.g. from **ProGet version 2024.25** to **version 2024.29**) you will likely be recommended to directly upgrade to the latest release. 

![Direct Upgrade](/resources/docs/myinedo-viewingupgradeguidance-directupgrade.png){height="" width="50%"}

From here, select “Upgrading your Inedo Product” for instructions on how to upgrade. Read the change logs to view the notes for each release spanning from your current version to your intended upgrade version.

### Recommended Upgrade

In some cases (e.g. upgrading from **ProGet version 5.3.44** to **version 2024.29,**) the latest version will still be recommended but notice or documentation will be offered when there are significant changes between versions.

![Upgrade Recommended](/resources/docs/myinedo-viewingupgradeguidance-upgraderecommended.png){height="" width="50%"}

![Latest Release Recommended](/resources/docs/myinedo-viewingupgradeguidance-latestversionrecommended.png){height="" width="50%"}

### Direct Upgrade Not Possible

If a direct upgrade is not possible (e.g upgrading from **version 3.8.5** to **version 2024.9**) we still provide an upgrade path. In such a case it is highly recommended that you read the provided documentation and change notes to mitigate any potential issues.

![Direct Upgrade Not Possible](/resources/docs/myinedo-viewingupgradeguidance-directupgradenotpossible.png){height="" width="50%"}

## Public Issue Tracker

Browse the change log and Inedo YouTrack page to determine any breaking changes or compatibility issues when upgrading your software.

### Public Issues Dashboard

Select the link to our Public Issue Tracker in the Upgrade Guidance page to view information on changes or fixes for your Inedo product. You can also compare the maintenance frequency of each software version at a glance, and select a specific version for further detail.

![YouTrack Dashboard](/resources/docs/myinedo-viewingupgradeguidance-youtrackdashboard.png){height="" width="50%"}

### Individual Issues

Select an issue number in the change log to directly access patch notes for the corresponding issue, e.g., the status of any releases or fixes.

![YouTrack Issues](/resources/docs/myinedo-viewingupgradeguidance-youtrackissues.png){height="" width="50%"}