---
title: Feeds in Proget
nav-title: "What is a  \"Feed\" in ProGet?"
order: 1
---

A feed is like a private 'app store', but for your own applications and components. They are used to store packages, container images, and other assets, and users can easily see what is available to download what they need. "Feed" is our collective term for registries, repositories, feeds, etc.

By [setting up multiple feeds](/docs/proget/feeds/feed-overview/proget-feed-groups#multiple-feeds), you can not only separate packages by package format and development group, but also use [package promotion](/docs/proget/packages/package-promotion) to identify high-quality and compliant packages for production. There are *no* limits to the number of feeds you can create, and all feed types are available in both the free and paid editions of ProGet.

You can [control who can access which feeds](/docs/proget/administration-security/proget-howto-self-service-feeds) and [assign granular privileges for performing specific tasks](/docs/proget/administration-security) in a feed. For example, you can allow anyone to view and download packages in all feeds, but only allow ". NET Developers" to publish packages in the "NuGet-Dev" feed.

## Creating and Managing Feeds

To create a new feed, go to `Feeds > Create New Feed`. You can also manage feeds from the Feeds page or by going to the specific feed page and clicking the `Manage Feed` button.

### Feed Name

All feeds have an "API Endpoint" URL that is used for (programmatic) API access, and the name of a feed becomes part of that endpoint URL. When naming a feed, you must use only URL-friendly characters. You can find this URL in the upper-right corner of the feed browse page.

Renaming a feed also changes its API Endpoint URL. As of ProGet 5.2.19, you can create "Alternate Names" for a feed by going to Manage Feed > Rename and then clicking the Set Alternate Names link in the warning dialog. Alternate feed names essentially provide multiple endpoint URLs for a feed and are useful when renaming feeds to maintain backward compatibility with old names.

### Feed Types & Usage 

When you create a feed, the feed type is fixed. This type defines two things:

 * **The Package Format that the feed will use**; for example, a NuGet feed will only store NuGet packages, and an npm feed will only store npm packages.
 * **API that will be used to programmatically access packages within the feed**; for example, a NuGet feed will only ever use the NuGet API, a npm feed will only use the npm API, etc

Some feeds have additional options that affect how they are displayed in the web user interface, such as icons and navigation options.

* **NuGet package type**: Chocolatey and PowerShellGet both use NuGet packages, and if you change the package type, the entire appearance of the feed changes
* **Feed usage**: This option is available in ProGet 5.3 and later, and options may include: 
  * *Free/Open Source packages*; Caching and filtering source packages from public galleries, scanning for vulnerabilities, checking licenses, etc. **Note:** At least one connector is required before packages are displayed.
  * *Private/Internal packages*; publish proprietary/private packages you build for internal use in your organization
  * *Validated/promoted packages*; promote packages that meet internal quality standards and are suitable for production use
  * *Mixed packages*: Host both third-party packages and packages that you create

The use of feeds controls which tabs and messages are displayed on the user interface. For example, Private/Internal Packages doesn't display the license filtering options because you'd not create license usage restrictions for your own packages.

Note that not all feeds have all of these Feed Usage options. In general, we don't recommend using mixed packages because then you'll see all the UI options, most of which aren't relevant to the packages you create (for example, license filtering or vulnerability scanning).

## Deleting a Feed 

A feed can either be deactivated or deleted. When you deactivate a feed, it is invisible to most of the user interface and no longer accessible through API endpoints.

Deleting a feed removes it completely from the software. All package data indexed in the database is deleted, as is metadata that is not stored in the package itself, such as publish dates and download counts for each package.

## Feed-level Features in ProGet 

You can configure your feeds in ProGet with a number of options to get the maximum value from ProGet, including but not limited to:

* [Connectors](/docs/proget/feeds/connector-overview) allow ProGet feeds to include and curate packages from an external source (e.g., another ProGet feed or another implementer of the package API, such as NuGet.org), filter and curate them, and to aggregate packages from multiple sources into one feed. All versions of ProGet can use connectors, making ProGet an ideal private proxy for a public feed like NuGet. [Connector filters](/docs/proget/feeds/connector-overview#connector-filters) are limited in the free versions of ProGet, and connections between ProGet instances are a violation of [the ProGet EULA](https://inedo.com/proget/license-agreement).

* [Feed replication](/docs/proget/replication-feed-mirroring/proget-advanced-feed-replication) is a feature in ProGet Enterprise that allows you to replicate packages between different ProGet instances around the world so that different teams can share feeds without having to set up a complicated global infrastructure.

* [Webhooks](/docs/proget/administration/proget-notifications-webhooks) allow you to integrate ProGet with other tools and notify users, trigger automated workflows, or audit events such as package creation and deletion. For example, Inedo's Slack channels include webhooks to notify you when new extensions, releases, and pre-releases are available to users.

* [Policies and Compliance Rules](/docs/proget/sca/policies) allow you to clearly define what "compliant" means for open-source packages, and easily define rules about licensing, vulnerability, deprecation, etc. to block download/usage of noncompliant packages.

* [Vulnerability Scanning and Blocking](/docs/proget/sca/vulnerabilities) can automatically scan third-party packages and Docker container images against vulnerability databases.

* [License Detection and Blocking](/docs/proget/sca/licenses) can help you manage licensing agreements of third-party, open-source packages. 

* Live Usage Scanning for [packages](/docs/proget/packages/package-scanners) and [containers](/docs/proget/docker/container-scanners) can connect to an external resource such as Otter or Kubernetes to collect and display how packages and Docker container images are used across your infrastructure.

* [Tracking package deployment](/docs/proget/packages/package-deployment) to see where packages have been deployed.

* View [package consumers](/docs/proget/installation/proget-old-versions-migration) for DLL packages to see what other packages and applications are using a specific package version.
