---
title: "Statements and Blocks "
order: 4
---

The execution engine interprets a [deployment plan](/docs/buildmaster/deployment-continuous-delivery/buildmaster-deployment-scripts)as a series of statements and blocks, in a top-down manner.

- Statements - most of the statements in your plans will be [operations](/docs/executionengine/overview/executionengine-components-operations-functions){target="_blank"}, but there are a few [other statements](/docs/executionengine/otterscript/statements-and-blocks/other-statments)that can help build extremely advanced plans
 <br>
- Blocks - blocks contain statements and other blocks, and help with organization and flow error control; there are four block types
    * [General Blocks](/docs/executionengine/otterscript/statements-and-blocks/general-blocks){target="_blank"}
    * [Loop Blocks](/docs/executionengine/otterscript/statements-and-blocks/loop){target="_blank"}
    * [Try /Catch Blocks](/docs/executionengine/otterscript/statements-and-blocks/try-catch){target="_blank"}
    * [If/Else Blocks](/docs/executionengine/otterscript/statements-and-blocks/executionengine-otterscript-if-else-blocks){target="_blank"}
    
If you're comfortable with programming or scripting, you may be already familiar with how these blocks work. There is a [Formal Specification](/docs/executionengine/reference/formal-specification)available if you want to know precisely how the execution engine and plans/OtterScript work.

## Blocks
Blocks provide an easy way to organize your plans, and the sub-tasks those plans are made of. They can be nested as many levels deep as you need, and all blocks provide variable scoping (i.e. if you set a variable in that block, it will only be available within that block) as well as log scoping.

## Log Scoping
BuildMaster's logs were designed to be as easy to navigate and understand as the plans. this is where collapsible log scopes come in:

#### Plan
![log-scoping-block.png](/resources/docs/log-scoping-block.png){height="" width=""}

#### Execution Log
![log-scoping-log.png](/resources/docs/log-scoping-log.png){height="" width=""}

If you give a block a **short description**, then the plan's execution log will have a scope of the same name. This way, as you nest statements and blocks in your plans, they will have the parity in the log.

Because logs may contain sensitive data, such as the arguments to a command line, you can restrict users from viewing debug-level logs. This offers an ideal mix between security/compliance and visibility.

## Assets in Plans
When an asset (template plan or script) is used in a plan, it is run as an operation, and can be treated in the same way (moved within a plan and have custom configurations). It is logged as an operation as well.

### More on this topic:
- [General Blocks](/docs/executionengine/otterscript/statements-and-blocks/general-blocks){target="_blank"}
- [Loop Blocks](/docs/executionengine/otterscript/statements-and-blocks/loop){target="_blank"}
- [Try / Catch Blocks](/docs/executionengine/otterscript/statements-and-blocks/try-catch){target="_blank"}
- [If / Else Blocks](/docs/executionengine/otterscript/statements-and-blocks/executionengine-otterscript-if-else-blocks){target="_blank"}
- [Other Statements](/docs/executionengine/otterscript/statements-and-blocks/other-statments)