---
title: "Chocolatey (Windows/Machine)"
order: 5
---

<h1>Chocolatey Feeds in Proget</h1>

[Chocolatey](https://chocolatey.org/) is a package manager for Windows. Similar to Linux tools like apt or yum, but designed specifically for Windows, Chocolatey is designed as a decentralized framework for quickly installing applications and tools you need.

## Prerequisite Configuration

ProGet is compatible with all versions of the Chocolatey client, going back to the first release in 2011.

:::(Internal) (TODO)
### Chocolatey Client Configuration
TODO: How to add as a source, note this is optional

### Testing Client Configuration
TODO: how to test using like `choco list` or something

TODO: note configuration file are these stored in
:::

## Installing Packages

There are four ways to add a package to your Chocolatey feed:

1. Push via Chocolatey Command Line:  
```
choco install {package-name} --version {package-version} --source http://{proget-server}/nuget/{feed-name}/
```
2. Upload from disk
3. Pull from [Chocolatey.org](https://chocolatey.org/) 
4. Bulk import existing Chocolatey packages


## Creating Packages

To learn how to create a package that can be hosted by ProGet, visit the [Creating Chocolatey Packages](https://chocolatey.org/docs/create-packages). 

:::(Internal) (TODO)
## Publishing Packages

NuGet Push or upoad?
:::


## NuGet Feed Differences

Because the Chocolatey API is built on top of the NuGet v2 API, a Chocolatey feed in ProGet is actually a [NuGet feed](/docs/proget/feeds/nuget) with some slight differences in behavior:

- Packages in Chocolatey feeds have a different icon to indicate that they are intended for use by Chocolatey
- The package installation instructions also include an example of installing the package using 'choco' instead of NuGet
- The [Package Usage feature](/docs/proget/feeds/chocolatey/proget-howto-scan-installed-chocolatey-packages) is enabled, while the Package Consumers feature is disabled
- [Internalized packages](/docs/proget/feeds/chocolatey/proget-howto-private-chocolatey-repository) can be hosted in Chocolatey feeds 

## ProGet + Chocolatey Webinar

In the following video, Chocolatey founder Rob Reynolds presents a demo of ProGet and Chocolatey, showing how the two combine to form a complete Windows package management solution.

ProGet's user interface has been updated since this video, but the instructions provided are still valid.

<iframe width="600" height="337" src="https://www.youtube.com/embed/BcTYGf7sQ8Q" frameborder="0" allowfullscreen="true"></iframe>
