---
title: "Helm (Kubernetes)"
order: 12
---

[Helm](https://helm.sh/) is the package manager for Kubernetes applications and uses a packaging format called [Charts](https://helm.sh/docs/topics/charts/) to define, install, and upgrade Kubernetes applications in a repeatable and versioned manner.

Charts can be stored and shared using a Helm feed in ProGet, which acts as a [Chart Repository](https://helm.sh/docs/topics/chart_repository/). You also [Create connectors](/docs/proget/feeds/connector-overview) to other Chart Repositories (including [Artifact Hub](#artifacthub)) that let you use third-party charts through a Helm feed and create a curated list of approved Helm Charts.

Helm feeds also allow you to see which container images are referenced by your Helm charts and help you discover vulnerabilities in images referenced by Helm charts.

## Adding a Helm Feed as a Repository

Before installing a chart from a Helm feed, the feed needs to be registered as a repository. You can use the [`helm repo add`](https://helm.sh/docs/helm/helm_repo_add/) command to do this:

```bash
helm repo add proget https://«proget-server»/helm/«feed-name»
```

We recommend using `proget` as the repository name or, if you have multiple Helm feeds configured, you should use `proget-«feed-name»` instead. When your feed is connected to Artifact Hub, you'll need to register additional repositories for charts.
 
### Authenticated Feeds

If your feed is not configured for anonymous access, then you'll need to authenticate to the Helm feed by specifying the `--username` and `--password` arguments. Rather than use your ProGet credentials we strongly recommend using an [API Key](/docs/proget/reference-api/proget-apikeys) for this, with `api` as the username, and the API Key as the password. See [Creating and Managing API Keys](/docs/proget/reference-api/proget-apikeys#creating-and-managing-api-keys) to learn more.

To authenticate to your feed, use the [`helm repo add`](https://helm.sh/docs/helm/helm_repo_add/) command, including your API key as a parameter:

```bash
helm repo add proget https://«proget-server»/helm/«feed-name» --username api --password «api-key»
```

## Installing Helm Charts

To install a chart from this repository, you can use the [helm install](https://helm.sh/docs/helm/helm_install/) command. 

```bash
helm install proget/«chart-name»
```

Note that, because Helm caches repository information locally, you should generally run the [helm repo update](https://helm.sh/docs/helm/helm_repo_update/) command first to ensure you'll get the latest version of the chart.

## Creating Your Own Helm Charts

There are no special requirements for creating Helm Charts in ProGet, but you will need to follow [image naming conventions in your Values file](#values-yaml) if you'd like ProGet to detect the container images that your chart references. You can learn more about creating your own Helm charts by reading [HOWTO: Create and Publish Helm Charts to a Private Repository](/docs/proget/feeds/helm/howto-helm-publish)

## Publishing Helm Charts

The easiest way to push a Helm Chart to your feed is to use [pgutil](/docs/proget/reference-api/proget-pgutil). To push the chart, use the [pgutil packages upload](/docs/proget/reference-api/proget-api-packages/proget-api-packages-upload) command:

```bash
$ pgutil packages upload --feed=«feed-name» --input-file=«path-to-chart-tgz»
```

If you're using ProGet 2023 or earlier, you can instead issue a `PUT` request with the package file as the content to the endpoint URL. For example:

```bash
curl https://«proget-server»/helm/«feed-name» --user api:«api-key» --upload-file «path-to-chart-tgz»
```

This method also works in ProGet 2024 and later, should you prefer to use that. Note that neither the `helm push` nor the  `helm-push` are compatible with ProGet feeds.

## Connecting to Artifact Hub { #artifacthub }

ProGet 2024.17+ support connecting a Helm feed to [ArtifactHub.io](https://artifacthub.io/), the defacto public source for open-source and publicly distributed Helm charts. Earlier versions of ProGet default to [Helm Stable](https://charts.helm.sh/stable/), which is no longer maintained.

Artifact Hub is not a Helm repository itself, but an aggregator of Helm repositories. When a Helm connector is configured to use the Artifact Hub API (i.e. `https://artifacthub.io/api/v1/`), ProGet will use a [special API](https://artifacthub.io/docs/api/) to search and download charts. Earlier versions of ProGet do not have this capability and will instead give an error message.

Helm charts that come from Artifact Hub will always be "prefixed" with a repository name. For example, the [kube-prometheus-stack](https://artifacthub.io/packages/helm/prometheus-community/kube-prometheus-stack) chart will appear as `prometheus-community/kube-prometheus-stack` in ProGet.

To install these charts, you'll often need to add an additional repository. The instructions for doing this will be on the Helm chart overview page in ProGet, and will look something like this:

```bash
helm repo add prometheus-community https://«proget-server»/helm/«feed-name»/prometheus-community
helm install prometheus-community/kube-prometheus-stack --version 65.2.0
```

This prefixed repository will persist if you promote the Helm chart to another feed or pull the package into ProGet. However, if you were to download the package file and then upload it again, the prefix will no longer be there.

At this time, it's not possible to create prefixes or namespaces like this. If you're interested in this functionality, [let us know](https://forums.inedo.com/). We can always consider it as an enhancement in a future version.

## Container Images & Values.yaml { #values-yaml }

To display the container images that a Chart Uses, ProGet will parse the Value Files (i.e. `values.yaml`) inside your Chart and link them to matching container images in your ProGet feeds. 

:::(Info) (💡 What is a Values File?)
The [Values Files](https://helm.sh/docs/chart_template_guide/values_files/) (i.e. `values.yaml`) is typically used to define the container images that will populate the [deployments file](https://kubernetes.io/docs/concepts/workloads/controllers/deployment/) (i.e. `templates/deployments.yaml` template file) used by Kubernetes.
:::

This relationship is also used to display the charts that reference a container image and to prevent docker images from being deleted during retention.

### Container Image Naming Conventions

When configuring container images in your `values.yaml`, the image property must end in _image_ (e.g., _image:_, _redisImage:_, _postgresImage:_, etc.) and contain the following sub-properties: _repository_, _tag_ (or _dockerTag_), and optionally _registry_.  If _tag_ or _dockerTag_ is omitted, the `appVersion` will be used when defining the associated container image.

For example, a single-container chart (i.e. the default created from the helm create command) should have the following entries in the `values.yaml` file in order for ProGet to detect it:

```yaml
image:
  repository: proget.corp.local/corp-images/corp/my-app
```

A multi-container chart might look like this: 

```yaml
myAppImage:
  repository: proget.corp.local/corp-images/corp/my-app

postgresImage:
  repository: proget.corp.local/dockerhub-images/postgres
  tag: 13.16
```

## Container Image Vulnerabilities

If you have configured your container registries to leverage ProGet's vulnerability scanning, then you may have a Helm chart that links to a vulnerable container image. This will be displayed on the "Vulnerabilities" tab of the Helm chart.

This can cause your Kubernetes installation to fail when you try to pull the container image from your registry. Container images will be blocked if a vulnerability has been assessed and marked `Blocked` or if you have enabled the `Unassessed` vulnerabilities to be blocked in "Administration Overview" > "Advanced Settings".

