---
title: "パッケージのパイプライン管理"
order: 4
hidden: true
---

ソフトウェア開発におけるパイプラインとは、開発からリリースまでの一連のプロセスのことを指します。CICDツールの登場により「パイプライン＝自動化」のIT用語というイメージもありますが、マーケティング、セールス、物流でも、同様に「パイプライン＝一連のプロセス」として使われてる、一般的な言葉です。

パイプラインの、次の工程に進むことを英語では一般的に「プロモーション」と言います。例えば、あるソフトウェアを開発フェーズからテストフェーズに移行することを「プロモーション」と言います。

物流業界や、製造業では、一般的にコンテナ（Dockerのコンテナではなく、貨物船のコンテナ）が工場に搬入され、次に検品（バーコードをスキャンして、数や品番が合っているかを確認する）されたら、品質確認のフェーズにプロモーションされます。

パッケージは、ソフトウェア開発の部品です。部品を NuGet など、外から持ってくるにしても、社内で開発するにしても、きちんとした品質管理プロセスは必要です。

ProGet には、パッケージの開発や検品をパイプライン化する、パッケージパイプライン機能があります。

## パッケージパイプライン機能の仕組と使い方
![ProGet-Pipeline-Promotion](/resources/docs/details-dev-process.gif){height="" width=""}

ProGet を導入すれば、サーバ上に複数のフィードを作成し、パッケージをフィード間で移動できます。
:::(Info) ()
フィードは、ProGet 内のパッケージ保管場所です。リポジトリも呼びます。フィードの詳細と作り方は、「パッケージフィードとは」をご覧ください、
:::

例えば、

1. NuGet の社内開発パッケージについて、「開発用」「テスト用」「本番用」、3つのフィードを作成する。
2. パッケージ開発チームは開発用フィードだけに、パッケージテストチームはテスト用フィードだけにアクセスできるようにProGet で設定する。
3. 製品開発チームは、本番用フィードのみからパッケージをダウンロードして製品開発できるように ProGet で設定する。

パッケージ開発チームは、開発が完了したパッケージをテストフィードに移動（プロモーション）し、テストチームは  OK ならパッケージを本番フィードに、ダメならパッケージを開発フィードに移動します。

このように、パッケージの開発とテストプロセスをパイプライン管理することにより、一定の品質と安全性基準のみを満たしたパッケージのみが製品に組み込まれるよう、品質管理ができます。

## パイプライン用のフィードを作り、プロモート先を指定する
新しいフィードを作成するには、[Feeds (フィード)] > [Create New Feed (新しいフィードの作成)] に移動します。次に、フィードの名前と、作成したフィードのパッケージタイプ（NuGet、RPM、自作など）を指定します。

:::(Info) ()
フィードの詳細と作り方は、「パッケージフィードとは」をご覧ください、
:::

フィードを作成したら、作成したフィードを開き、 画面の右上にある [Manage Feed (フィードの管理)] ボタンをクリックします。

次に、Promote To Feed の右端にある [Change (変更する)] ボタンをクリックして、プロモート先を指定します。

おすすめの名前は、チームが見て、そのフィードに何が入っているか、また新たなパッケージをどこに入れればよいのか、一目でわかる名前です。

また、一般的に、自社開発パッケージと、サードバーティのパッケージは、別々のフィードに整理することをおすすめします。

最後に、コネクタ機能を使って、NuGet.org などのパブリックライブラリや、社内のファイルサーバにあるパッケージを、ProGet で管理できる、キャッシュできるようにすれば完了です。
![Proget-promote_package](/resources/docs/Proget-promote_package.png){height="" width=""}


## パッケージをプロモーションする
パッケージをプロモートするには、2つ方法があります。手動と、API による呼び出しです。

### 手動でパッケージをプロモーションする
1. プロモートしたいパッケージを開く
2. プロモートしたいバージョンを開く
3. 右上の [Download Package (パッケージをダウンロード)] の右にある ▼ をクリック
4. [Promote Package (パッケージをプロモートする)] をクリック

:::(Info) ()
無料版では、パッケージの手動プロモーションはできますが、API によるプロモーションはできず、また誰が、いつ、なぜプロモートしたかをトラッキングできません。
:::


### API でパッケージをプロモーションする
API によるパッケージプロモーションをするには、最初にアクセスを許可する API キーを生成する必要があります。API によるパッケージプロモーションの詳細は、弊社の [API リファレンス（リンク先英語）](/docs/proget/reference-api)をご覧ください。

## パッケージ プロモーション の権限管理
ProGet は、フィードとタスクごとに、ユーザの権限を管理できます。

そのため、どのユーザが、どのフィードのパッケージをプロモーションできるか、アクセスと権限の管理ができます。

パッケージのプロモーションを許可するには、少なくともプロモーション元（ソースフィード）の表示とダウンロードも許可する必要があります。

## パッケージプロモーションのログ
![Proget-package-promotion-log](/resources/docs/Proget-package-promotion-log.png){height="" width=""}

ProGet は、パッケージのプロモーションログを記録し、以下の履歴を確認できます。

* プロモーションの日時
* プロモーションを実行したユーザ
* ソースフィード（プロモーション元）
* ターゲットフィード（プロモーション先）
* コメント