---
title: "Installation & Upgrading"
order: 2
---

Installing the Inedo Agent is really easy with our user-friendly, GUI-based installer. Simply follow the step-by-step guide below.

Alternatively, you can use [silent installation](/docs/inedo-agent/inedoagent-installation-installation-guide/inedoagent-installation-silent-installation) or [manual installation](/docs/inedo-agent/inedoagent-installation-installation-guide/inedoagent-installation-manual) options to help automate installation and management.

## Pre-Installation Check List 

The Inedo Agent will run on all modern version of Windows (7+/2008+), and has no hardware requirements outside of Microsoft's minimal [Windows Server requirements](https://learn.microsoft.com/en-us/windows-server/get-started/hardware-requirements). 

However, before installing, consider the following:
- **.NET Framework is Required**; this is already installed on most Windows servers, and can be [installed as a feature](https://learn.microsoft.com/en-us/dotnet/framework/install/) under .NET Framework 4.x Features > .NET Framework 4.x if it's not
- **Open a Firewall Port (Inbound)**; the Inedo Agent will listen on the port of your choosing (default 46336), which will likely require an open port in Windows Firewall and any other firewalls you use

You can open a Firewall Port using the Windows Firewall GUI (see [Creating an Inbound Port Rule](https://learn.microsoft.com/en-us/windows/security/threat-protection/windows-firewall/create-an-inbound-port-rule)), or by using a PowerShell script like this: 

```(powershell)
New-NetFirewallRule -DisplayName "Inedo agent" -Direction Inbound -LocalPort 46336 -Protocol TCP -Action Allow
```

## 1. Download the Inedo Agent

We recommend downloading the latest version of the installer, which you can find here:

<a href="http://cdn.inedo.com/downloads/inedo-agent/InedoAgentSetup.exe" style=" background:#025291;color:#ffffff;padding: 6px 20px;  border-radius: 3px;font-size: 14pt;text-decoration:none">Download Inedo Agent Installer (latest)</a>

You can also download older versions from the [Agent Versions & Release Notes](/docs/inedo-agent/inedoagent-versions) page.

:::(Warning) (Unsafe Alert or "Virus" Notice?)
Depending on the browser you use or the malware detection heuristics, you may receive an "unsafe" warning. This is a "false positive", and you can ignore it.

If the installer is signed by Inedo, you can be assured it's safe. See [Anti-malware False Positives, Code Signing, and Safety of Inedo Products](https://inedo.com/support/kb/1113/false-positive) to learn more.
:::

## 2. Target Directory 

You may install wherever you like; this is not where temporary files will be stored.

![agent-install-1](/resources/docs/agent-install-1.png){height="" width="50%"}

## 3. User Account

By default, the agent service will run as [LocalSystem](https://msdn.microsoft.com/en-us/library/windows/desktop/ms677973(v=vs.85).aspx), which is an administrative service account. While not required, administrator-level privileges are strongly recommended as it will eliminate any difficulty or confusion with moving files and running different operations.

![agent-install-2](/resources/docs/agent-install-2.png){height="" width="50%"}

You can change this later by using the Windows Service Manager, and changing the account that the service is configured to use. See [Security Requirements](/docs/inedo-agent/inedoagent-installation-installation-guide/inedoagent-installation-security) to learn more.

## 3. Network & Security Settings

In this step, you'll select the Agent Port and Agent Security settings.

![agent-install-3](/resources/docs/agent-install-3.png){height="" width="50%"}

You can change these settings later by [editing the configuration file](/docs/inedo-agent/maintenance-configuration/inedoagent-configuration-configuration-file), and restarting the service.

### Agent Port

We recommend using the default port (46336), as that's Inedo's [officially designated port](http://iana.org/assignments/port-numbers). Make sure that the selected port is not blocked by a firewall.

### Agent Security

Inedo's agents use a FIPS-compliant symmetric AES encryption scheme by default, and the installer will automatically generate a secure, 32-digit key for you. You can use that key, or another one of your choosing.

If you select SSL instead of built-in AES, then you will need to have a valid certificate installed on the server.

:::(Error)
**No Encryption** is also an option, but we don't recommend using it. The primary reason we have this is so that you can use a tool like [Wireshark](https://www.wireshark.org/) to inspect the individual messages, either as directed by our support engineers or because you really like studying binary TCP protocols.
:::

## 4. Confirmation & Install 

Verify that the information here is correct and then click Install.
![agent-install-4](/resources/docs/agent-install-4.png){height="" width="50%"}

After you do that, the Inedo Agent service will be installed and running.

:::(Warning)
**Installation will be near instantaneous**, on even the slowest of systems. If you want to verify that the installation actually occurred, just check that the Inedo Agent service was installed and is running.
:::

## 5. Copy AES Key (Optional)
If you selected AES as the Agent Security option, the installer will generate a key and save it in [the Inedo Agent configuration file](/docs/inedo-agent/maintenance-configuration/inedoagent-configuration-configuration-file). 

It will also be presented after installation.

![agent-install-5](/resources/docs/agent-install-5.png){height="" width="50%"}

You will need to supply this key to BuildMaster or Otter to use the agent.
