---
title: "LDAP/AD Integration"
order: 5
---

Inedo products come with built-in users and groups, but it can also [integrate with an external directory service like Active Directory](/docs/installation/security-ldap-active-directory/various-ldap-ldap-active-directory) and other LDAP-based services. This allows you to use the organization's existing users, logins, and groups to secure the product and define the tasks users are permitted to do. 

Administrators can also enable Single-Sign On (i.e. [Windows Integrated Authentication](/docs/installation/security-ldap-active-directory/various-ldap-integrated-authentication)) so that end-users don't have to enter their username/password to use the product.

## Built-in Users & Groups

When an Inedo product is first installed, a default administrator username/password (`Admin`/`Admin`) will be created. You should obviously change this password or delete this user once configured the product. You can also disable Built-in User Sign-on completely, which means users will only be able to log-in using their external (i.e. Active Directory/LDAP) credentials.

:::(Warning) (Can't Log-in and Locked Out?)
If you ever get "locked out" of an Inedo product, either due to misconfiguration or a lost password, see [Locked out: Restoring Default Admin Account](/docs/installation/security-ldap-active-directory/various-ldap-troubleshooting#locked-out) to restore the default `Admin`/`Admin` account and reenable Built-in User Sign-on. 
:::



### Built-in Users/Groups in the Database

The users, logins, and groups you create in the product are called "Built-in Users & Groups", and are stored in the product's database (specifically, the `Users`, `Groups`, and `UserGroups` tables). Note that the passwords themselves are not directly stored; instead, passwords are cryptographically hashed/salted (see [OWASP's Password Storage Guidelines](https://cheatsheetseries.owasp.org/cheatsheets/Password_Storage_Cheat_Sheet.html#hashing-vs-encryption)). 

## Importing and Exporting Security Configuration
You can import or export users/groups and tasks/permissions as JSON documents. This can be useful for diagnostic purposes, bulk editing or migration of instances.

* To import or export users/groups, navigate to Admin > Manage Security > Built-In Users & Groups and then select either "Export Users & Groups" or "Import Users & Groups".

* For Tasks/Access Rights, navigate to Admin > Manage Security > Tasks/Access Rights, and then select either "Export Tasks" or "Import Tasks".

This feature is available from ProGet 2022, BuildMaster 2022 and Otter 2022.

## Domains & Active Directory/LDAP Integration 

Inedo products use a User Directory to validate logins and find usernames and user groups in an external directory service. While it's possible to create a custom user directory component using the [Inedo.SDK](/docs/inedosdk), nearly all users will have one or more of the [LDAP/AD User Directory Types](#ldapad-user-directories-versions) configured. 


## Configuring Multiple Directories / Domains

:::(Info)
This functionality describes functionality starting in ProGet 2022, BuildMaster 2022, and Otter 2022. This is is available as a preview feature in ProGet 6.0.8+.
:::

You can configure as many user directories as you need and enable the directories you want to search. If there are multiple enabled user directories, they will all be used to search for users/groups and verify logins.

For example, if `mycompany.corp` and `trusteddomain.corp` are both configured, and the Built-in User Sign-on is Enabled:

 * If you enter `jdoe` in a search box then you may see:
   * `jdoechestor` (from the Built-in Users)
   * `jdoeson@mycompany.corp`
   * `jdoe@trusteddomain.corp`
   * `jdoedawn@trusteddomain.corp`
 
 * When a user logs in with `jdoe` and `hunter42`
   * the Built-in Users will be used to validate the login, and if that fails...
   * the `mycompany.corp` domain will be used, but if that fails...
   * the `trusteddomain.corp` domain will be used
   * the user will get an "invalid login" error if they all fail

As a result, this behavior may yield to logging of failed logins. The exception to behavior is if the username contains a `@` or `\` symbol, such as `jdoe@mycompany.corp` or `COMPAN\jdoe`. In that case, only the domains that matching that name searched.

### Hybrid User Directory
Prior to ProGet 2022, BuildMaster 2022, and Otter 2022, you could create a [Hybrid User Directories](/docs/installation/security-ldap-active-directory/various-ldap-combining-with-built-in) to approximate this behavior.

Upon upgrading to these versions, the Hybrid User Directory will be removed and the associated directories will be enabled.

## Configuration in Earlier Versions

:::(Info)
This describes the behavior of ProGet 6.0, BuildMaster 7.0, Otter 3.0, and earlier. 
:::

Only one user directory can be active at a time: either the built-in one or one of the configured LDAP/AD directories) for querying.

This approach has some disadvantages:

 * It is easy to get locked out; if there is a configuration problem, you must follow the reset instructions to fix it
 * Migration of domains is tedious; because each of these directories uses its own permissions, if you want to configure a different user directory, you must recreate all of those permissions

## LDAP/AD User Directories Versions

Active Directory installations can be complex, and it's not uncommon for users to integrate our products into a decades-old multi-domain forest with tens of thousands of users. Over the years, we have found better ways to integrate into a variety of configurations. However, because there is a risk of authentication breaking down, we have introduced major changes as a new type of user directory.

### v1: LDAP or Single Domain Active Directory (Legacy)

This worked for most customers who only wanted to authenticate via LDAP or integrate into a single domain. It allowed custom mapping of LDAP property names... which in hindsight wasn't necessary. All the directories we saw in practice followed the same conventions.

### v2: Active Directory Domain Forest (Legacy)

This fixed a major bug in v1: It only queried a single domain, which was a problem for organizations that wanted to enroll users from multiple domains. This user directory removed the unnecessary field matching and searched all domains in an Active Directory forest instead of performing LDAP queries for one domain.

### v3: Active Directory / LDAP (Legacy)

This was a complete rewrite that effectively combines the concepts of v1 and v2. It can search multiple domains (each with different credentials) and provides several AD -specific features such as the ability to search gMSA accounts.

See [Advanced Configuration (v3)](/docs/installation/security-ldap-active-directory/various-ldap-v3-advanced) to learn more.

### v4: Active Directory/LDAP (Current)

This version is based on v3 with additional optimizations, enhanced LDAP filtering, and is bound to a single domain, simplifying LDAP queries. It also includes a new Microsoft Active Directory Group Search Type for improved LDAP query performance and customization, and supports large forests and other LDAP providers.

Task and permission configurations are compatible with both v3 and v4 and allow easy rollback between user directories. This preview feature is included in the InedoCore v2.2.1 extension available in ProGet v2022.20+ and BuildMaster v2022.0+.

See [Advanced Configuration (v4)](/docs/installation/security-ldap-active-directory/various-ldap-v4-advanced) to learn more.
