---
title: "Upgrading from BuildMaster v5"
order: 98
---

<section class="warningBox"><div class="content"><div class="content">BuildMaster v5 is <strong>semi-retired</strong>, which means that we will provide very limited support to users who have not yet upgraded and will assist with upgrades. However, we will no longer provide maintenance releases, patches, or other changes.&nbsp;</div></div></section><section class="errorBox"><div class="title">Do Not Upgrade to BuildMaster v5</div><div class="content">There is no need to perform incremental upgrades, and we do not recommend upgrading from any version of BuildMaster v5 to any other version.<br><br><ul><li><strong>Using v3 or v4?&nbsp;</strong>See <a href="/docs/buildmaster/installation-maintenance/buildmaster-upgrading/upgrading-from-buildmaster-v3-and-v4" rel="nofollow" translate="no">Upgrading from BuildMaster v3 and v4</a> to learn upgrade options</li><li><strong>Using v5?</strong> Upgrade directly to BuildMaster 6.1 (see <a href="/docs/buildmaster-upgrading-to-6-1" rel="nofollow" translate="no">Upgrading to BuildMaster 6.1</a>)</li></ul></div></section><p class="info">BuildMaster v5 was a release designed to modernize the platform and software, introducing a variety of changes through nine different releases. This article is a compilation of all upgrade notes from BuildMaster 5.0 to 5.8 and covers the changes that may affect your installation, configuration, and customizations of BuildMaster.&nbsp;</p><h2>Change Summary</h2><p>The following table summarizes all of the changes introduced throughout v5, and more details can be found below. In addition to these changes, there are two important things to note:</p><ul><li>Major SDK Changes will require a rebuild</li><li>All extensions will need to be reloaded</li></ul><table border="1" cellpadding="2" cellspacing="0" width="700"><tbody><tr><td valign="top">BuildMaster 5.0</td><td valign="top"><ul><li>.NET 4.5 is required</li><li>User Experience Changes</li><li>New Execution Engine / Legacy Plans</li><li>Workflows renamed to Pipelines</li><li>Deprecated features removed</li><li>Roles were renamed to Tasks and Rebuilt</li><li>UTC for Deploy Artifact Action</li><li>All Extensions Must be Upgraded</li></ul></td></tr><tr><td valign="top">BuildMaster 5.1</td><td valign="top"><ul><li>New Agent Model / Legacy BuildMaster Agents</li><li>New Feature: Resource Credentials</li><li>Resource Credentials for SSH-based Servers</li><li>New SSH Library</li><li>Encryption Key</li><li>All Extensions Must be Upgraded</li></ul></td></tr><tr><td valign="top">BuildMaster 5.2</td><td valign="top"><ul><li>New Feature: Server Roles (replacing Server Groups)</li><li>New Feature: API Keys (replacing ApiKey)</li><li>New Feature: Infrastructure Configuration Import/Export</li><li>New Feature: Infrastructure Synchronization</li></ul></td></tr><tr><td valign="top">BuildMaster 5.3</td><td valign="top"><ul><li>New Feature: Release Templates</li><li>New Feature: Configuration Variables / Legacy Variables</li><li>Core functionality moved to BuildMasterCore Extension</li></ul></td></tr><tr><td valign="top">BuildMaster 5.4</td><td valign="top"><ul><li>New Feature: Agentless Windows Servers</li><li>Changes to the Internal Artifact Disk Store Structure</li><li>New Feature: Variables Management API</li></ul></td></tr><tr><td valign="top">BuildMaster 5.5</td><td valign="top"><ul><li>New Feature: Pipeline Variables</li><li>New Feature: Variables as JSON</li><li>New Feature: Release &amp; Package Deployment API</li><li>Built-in Task Rebuild</li></ul></td></tr><tr><td valign="top">BuildMaster 5.6</td><td valign="top"><ul><li>New Feature: Issue Sources</li><li>New Feature: Source Control Operation Changes</li><li>Providers as a Legacy Feature</li><li>GitLegacy and GitHubLegacy Extensions</li></ul></td></tr><tr><td valign="top">BuildMaster 5.7</td><td valign="top"><ul><li>New Feature: Calendars feature</li><li>New Feature: Deployment windows</li><li>New Feature: Release target dates</li><li>Configuration file deployment changes</li><li>Edition Name Changes</li><li>New Extension Loader</li></ul></td></tr><tr><td valign="top">BuildMaster 5.8</td><td valign="top"><ul><li>New Feature: Text Templating</li><li>New Feature: Updated LDAP Directory and Active Directory</li><li>New Feature: Plan Versioning</li></ul></td></tr></tbody></table><h2 id="upgrade-process">Upgrade Process</h2><section class="errorBox"><div class="title">Do Not Upgrade to BuildMaster v5</div><div class="content"><span style="color: rgb(126, 17, 21); font-family: Nunito, sans-serif; font-size: 16px; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: 0.48px; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(249, 226, 228); text-decoration-thickness: initial; text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">There is no need to do incremental upgrades, and w</span>e do not recommend upgrading to any version of BuildMaster v5 from <em>any&nbsp;</em>version.<br><br><ul><li><strong>Using v3 or v4?&nbsp;</strong>See <a href="/docs/buildmaster/installation-maintenance/buildmaster-upgrading/upgrading-from-buildmaster-v3-and-v4" rel="nofollow" translate="no">Upgrading from BuildMaster v3 and v4</a> to learn upgrade options</li><li><strong>Using v5?</strong> Upgrade directly to BuildMaster 6.1 (see <a href="/docs/buildmaster-upgrading-to-6-1" rel="nofollow" translate="no">Upgrading to BuildMaster 6.1</a>)</li></ul></div></section><p>You can upgrade from any BuildMaster 5.x version to the latest BuildMaster 6.1 simply by downloading and running the installer.</p><h4 id="risk-mitigation">Risk Mitigation</h4><p>Although the risks vary depending on which 5.x version you're upgrading from, you should take the following precautions to avoid downtime:</p><ul><li>Make sure your BuildMaster database has been backed up prior to upgrading</li><li>Make sure your encryption key has been backed up before upgrading</li><li>Make sure the installation's \Extensions directory is backed up before upgrading</li></ul><h4 id="rollback">Rollback</h4><p>Since there are changes in the database, a rollback requires uninstalling BuildMaster and then <a href="/docs/installation/backing-up-restoring">restoring your BuildMaster instance</a>.</p><h2 id="45-required">.NET 4.5.2 Required</h2><p><strong>BuildMaster 5.0</strong> introduced a requirement that .NET Framework 4.5.2+ or higher be installed on the BuildMaster server and for all BuildMaster agents. This is a highly compatible, direct update to . NET Framework 4, and is already included in Windows 8 and Windows Server 2012. For older machines, simply <a href="http://microsoft.com/en-us/download/details.aspx?id=30653" rel="noopener noreferrer" target="_blank">download .NET 4.5 from Microsoft</a> and install the update.</p><h2 id="user-experience">User Experience Changes</h2><p><strong>BuildMaster 5.0&nbsp;</strong>introduced a Web Interface Overhaul to focus on Release Automation. In addition to color, font, and basic layout updates, the first thing you'll notice is the continued shift toward application release automation. Although we will continue to support the "create a build and deploy to production" workflow indefinitely, this workflow is becoming increasingly unpopular as CI servers like TeamCity, Jenkins, TFS, etc. become the preferred build tool and universal package managers like ProGet become the preferred artifact store.<br><br>The most noticeable change is in terminology: "promotions" are now "deployments", and "workflows" are now "pipelines".&nbsp;</p><div class="attention best-practice"><section class="infoBox"><div class="content">In hindsight, this was not a good idea. With BuildMaster 6.1, we have largely reversed this change and are focusing on BuildMaster as a CI/CD platform with the primary use case of "create a build and deploy it to production".</div></section></div><h2 id="execution-legacy">New Execution Engine / Legacy Plans</h2><p><strong>BuildMaster 5.0&nbsp;</strong>has added the Inedo Execution Engine (OtterScript) for deployment plans. To mitigate upgrade risk, this new execution engine has been implemented in parallel with the legacy execution engine. Although the new execution cannot run a legacy plan (and the legacy engine cannot run a new OtterScript plan), you can convert legacy plans to OtterScript on a plan-by-plan basis and then edit the corresponding pipeline to use the new plan.&nbsp;</p><p>See <a href="/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-features/buildmaster-legacy-plans" rel="nofollow" translate="no">Legacy Plans in BuildMaster 5.0</a></p><h2 id="workflows-pipelines">Workflows Renamed to Pipelines</h2><p><strong>BuildMaster 5.0</strong> renamed Workflows to Pipelines. While conceptually similar, the feature was completely reimplemented, and pipelines are quite a bit more versatile. There are a few notable changes:</p><ul><li><strong>Stages vs. Environments</strong> - a workflow represents a sequence of environments, while a pipeline is a sequence of stages; a stage can target zero or more environments&nbsp;</li><li><strong>Targets</strong> - in addition to an environment, a target also specifies servers; this means you do not have to explicitly name the servers you want to use in your plans&nbsp;</li><li><strong>Build Step Removed</strong> - there is no longer a specific build step; you can simply add a stage and add a build importer to it&nbsp;</li><li><strong>Gates</strong> - these are the same as the pre-deployment checklist&nbsp;</li></ul><h2 id="deprecated-features">Deprecated Features Removed</h2><p><strong>BuildMaster 5.0</strong>. The Notifiers and Triggers that were replaced with Event Listeners in BuildMaster 4.4 were removed; there were warnings about them in several versions (especially in 4.9). The Global environment approvals were also removed; these were also deprecated in BuildMaster 4.4.&nbsp;</p><h2 id="roles-tasks-rebuilt">Roles were Renamed to Tasks and Rebuilt</h2><h4>BuildMaster 5.0</h4><p>As part of the UX revision, Roles have been renamed to Tasks, and role names have been updated to sound more like tasks. &nbsp;<a href="/docs/buildmaster/installation-maintenance/buildmaster-upgrading/upgrading-from-buildmaster-v5/buildmaster-installation-and-maintenance-legacy-features-and-migration-upgrading-from-buildmaster-v5" rel="nofollow" translate="no">Permission Updates in BuildMaster 5.0</a> provide more details about this change.&nbsp;</p><h4>BuildMaster 5.5</h4><p>The five integrated tasks ( Administer, Coordinate Releases, Manage Application, View Application, and Deploy to Environment) have been rebuilt, which means that any customizations made to these tasks will be lost. If you did not heed the warning about modifying built-in tasks, you should rename the tasks to something else before upgrading. Custom tasks are not affected.<br><br>Also, the Environments_Manage attribute has been renamed to Infrastructure_Manage, and the Environments_View attribute has been removed altogether.</p><h2 id="utc-deploy-artifact">UTC for Deploy Artifact Action</h2><p><strong>BuildMaster 5.0</strong> now uses UTC times to compare artifacts on destination servers. This may cause BuildMaster to deploy the full artifact on the first deployment after upgrading as timestamps are no longer matched using local time.</p><h2 id="new-agent-model">New Agent Model / Legacy BuildMaster Agents</h2><p><strong>BuildMaster 5.1</strong> added support for the <a href="/docs/inedo-agent/inedoagent-overview">Inedo Agent</a> and renamed the previous agents to the Legacy BuildMaster Agent. See <a href="/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-features/buildmaster-upgrading-to-v5-agent-comparison" rel="nofollow" translate="no">Upgrading Legacy BuildMaster Agents to The Inedo Agent</a> for more information.</p><h2 id="resource-credentials">New Feature: Resource Credentials</h2><p><strong>BuildMaster 5.1</strong> added a new feature called Resource Credentials that is used for passwords and other secrets. See <a href="/docs/buildmaster/configuring-for-your-team/buildmaster-administration-resource-credentials">Resource Credential</a> documentation for more information.</p><h2 id="ssh-based-servers">Resource Credentials for SSH-based Servers</h2><p><strong>BuildMaster 5.1</strong> removed support for having SSH-based servers store the credentials and/or private keys on the server itself. Instead, a <a href="/docs/buildmaster/configuring-for-your-team/buildmaster-administration-resource-credentials">resource credential</a> must be created, and then associate with the server. Existing SSH-based servers will still function but when you edit a server, you will need to associate it with a resource credential.</p><h2 id="new-ssh-library">New SSH Library</h2><p><strong>BuildMaster 5.1</strong> changed the SSH library used to communicate with Linux-based servers. This should have no functional impact, and although the new library (libssh2) is popular and actively maintained compared to the old library (SSH.NET), the library change poses some risk for use on Linux-based servers.</p><h2 id="encryption-key">Encryption Key</h2><p><strong>BuildMaster 5.1</strong>. To encrypt <a href="/docs/buildmaster/configuring-for-your-team/buildmaster-administration-resource-credentials">resource credentials</a>, an encryption key is used; this will be created during the upgrade and added to the web and service configuration files. This encryption key must be added to your backup plan, or you will not be able to decrypt resource credentials on a resto</p><h2 id="server-roles">New Feature: Server Roles (Replacing Server Groups)</h2><p><strong>BuildMaster 5.2</strong> introduced the <a href="/docs/buildmaster/administration-agents-and-infrastructure/buildmaster-servers#servers-vs-roles">Server Roles</a> feature as a replacement for Server Groups, and Server Groups will be hidden unless you have Legacy Plans</p><p>In Legacy Plans, the Server Groups feature allowed actions or action groups to target multiple servers. Because Operations in OtterScript plans cannot target a server group (although you can iterate over servers to provide exactly the same functionality), they provide no value to non-legacy users and are hidden from UI if no legacy plans exist.</p><p>Servers can still be grouped using Server Roles, which is a new feature in this release. Roles can be the target of a pipeline stage and can be iterated just like server groups.</p><h2 id="api-keys-feature">New Feature: API Keys (Replacing ApiKey)</h2><p><strong>BuildMaster 5.2</strong> introduced the <a href="/docs/buildmaster/configuring-for-your-team/buildmaster-administration-security#api-keys">API Keys</a> feature. If you have configured an ApiKey for BuildMaster in All Settings, it will automatically be converted to an API Key with Native API access.&nbsp;</p><h2 id="infra-config-import-export">New Features: Infrastructure Configuration Import/Export &amp; Synchronization</h2><p><strong>BuildMaster 5.2&nbsp;</strong>introduced the <a href="/docs/buildmaster/administration-agents-and-infrastructure/sync">Configuration Import/Export</a> and <a href="/docs/buildmaster/administration-agents-and-infrastructure/sync#sync">Infrastructure Synchronization</a> features.</p><h2 id="release-templates">New Features: Release Templates</h2><p><strong>BuildMaster 5.3</strong> introduced the <a href="/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-applications-releases-templates">Release Templates</a> feature in conjunction with deprecating the existing variables that are used on releases and release packages.</p><h2 id="config-variables-legacy">New Feature: Configuration Variables / Legacy Variables</h2><p><strong>BuildMaster 5.3</strong> introduced a new variables feature called <a href="/docs/buildmaster/otterscript-execution-engine/buildmaster-variables">Configuration Variables</a>. Any existing configuration or release template variables you created are now legacy variables in the UI; Release Templates and Configuration Variables were implemented side by side to replace them.</p><p>See <a href="/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-features/buildmaster-installation-and-maintenance-legacy-features-variables" rel="nofollow" translate="no">Legacy Configuration and Release Variables</a> for more information</p><h2 id="agentless-windows-servers">New Feature: Agentless Windows Servers</h2><p><strong>BuildMaster 5.4</strong> introduced a new agentless means of communicating with Windows servers via PowerShell remoting channels.</p><h2 id="legacy-storage-paths">Changes to the Internal Artifact Disk Store Structure</h2><p>Although accessing artifact files directly in the artifact disk store (i.e. <code>ArtifactsBasePath</code>) is unsupported, many users wrote external scripts and tools that rely on doing exactly this.</p><p>In previous versions of BuildMaster, artifacts were stored using the following structure:</p><pre>\«application-id»
  \«release-number»
    \«package-number»
      \«deployable-id»
        \«artifact-name».zip</pre><p>As of BuildMaster 5.4, newly-created artifacts will be stored in the following manner:</p><pre>\A«application-id»
  \R«release-id»
    \B«package-id»
      \«artifact-name».zip</pre><p>If you rely on these internal paths, you'll have a problem with newly created artifacts. Of course, you should set the external tool to not use these paths... but in the meantime, there are two options you can use:</p><ul><li><strong>Use Legacy Storage Path</strong> - both the Create Artifact Operation and Create Artifact Legacy Action have a new property called <em>Use Legacy Storage Path</em> that defaults to false. When set to <code>true</code>, the artifact will be stored using the earlier convention</li><li><strong>Create Legacy Artifact Storage Symlinks</strong> - if you're in a bind because you didn't know something in the pipeline depended on it (e.g., a production deployment), the simplest quick fix may be to use the tool built into the service executable (bmservice.exe), which creates symbolic links for all existing "new path" artifacts in the old, expected location. Just run bmservice.exe, select the option, and the problem should be fixed immediately. Then change your plans to use the "Use Legacy Storage Path" property, or (ideally) fix your external tool</li></ul><h2 id="variables-management-api">New Feature: Variables Management API</h2><p><strong>BuildMaster 5.4</strong> added the <a href="/docs/buildmaster/reference/api/variables">Variables Management API</a> which lets you update configuration variables with a simplified API endpoint.</p><h2 id="pipeline-variables-json">New Features: Pipeline Variables and Variables as JSON</h2><p><strong>BuildMaster 5.5</strong> introduced variables to pipelines and pipeline stages, as well as the ability to bulk edit configuration variables as JSON documents.</p><h2 id="release-management-api">New Feature: Release Management API</h2><p><strong>BuildMaster 5.5</strong> added the <a href="/docs/buildmaster/reference/api/release-and-build">Release and Package Deployment API</a> offers a simple mechanism for creating releases, creating release packages, and deploying release packages.</p><h2 id="issue-sources">New Feature: Issue Sources</h2><p><strong>BuildMaster 5.6</strong> added the <a href="/docs/buildmaster/modeling-your-applications/buildmaster-applications-issue-tracking#issues-sources">Issue Sources Feature</a> to replace the Issue Tracking Providers, which are now considered a legacy feature.</p><h2 id="source-control-op-providers">Source Control Operations &amp; Providers as a Legacy Feature</h2><p><strong>BuildMaster 5.6</strong> has deprecated the "provider model" in favor of using Resource Credentials and Global Variables for configuration and tool-specific Operations. So instead of "Get-Latest using SVN", it would be "SVN-Checkout". Therefore, both Issue Tracking Providers and Source Control Providers are considered legacy features.</p><h2 id="calendars-windows-targets">New Features: Calendars, Deployment windows, and Release target dates</h2><p><strong>Buildmaster 5.7</strong> introduced several related features: <a href="/docs/buildmaster/modeling-your-applications/buildmaster-releases/buildmaster-applications-releases-calendars">Calendars</a>, <a href="/docs/buildmaster/deployment-continuous-delivery/automated-testing-verification-automatic-manual-approvals/buildmaster-ci-cd-testing-and-verification-approvals-deployment-windows">Deployment Windows</a>, and Release Target dates.</p><h2 id="config-file-deploy-changes">Configuration file deployment changes</h2><p><strong>BuildMaster 5.7</strong> introduced changes to configuration file deployment, with the biggest change in behavior being the removal of %-syntax variable support when deployment occurs in an OtterScript plan. The behavior was previously undefined, e.g. sometimes it performed the replacement, whereas other times it did not. See the full <a href="/docs/buildmaster/deployment-continuous-delivery/buildmaster-applications-configuration-files">Configuration File Assets documentation</a> for more information and specification.</p><h2 id="edition-name-changes">Edition Name Changes</h2><p><strong>BuildMaster 5.7.&nbsp;</strong>What used to be called "BuildMaster Enterprise" is now "BuildMaster Standard." The only change in the software is that the license key pages mention Standard instead of Enterprise. This does not change the functionality.</p><h2 id="text-templating">New Feature: Text Templating</h2><p><strong>BuildMaster 5.8</strong> allows you to use the Apply-Template operation to perform advanced text replacement. <a href="/docs/executionengine/overview/executionengine-components-text-templating">Templating</a> is part of the SDK, so it can also be used by custom extensions.</p><p>This feature can be used in combination with <a href="/docs/buildmaster/otterscript-execution-engine/buildmaster-variables">Configuration Variables</a> as the simplest mechanism to deploy configuration files.</p><h2 id="updated-ldap-directory">New Feature: Updated LDAP and Active Directory</h2><p><strong>BuildMaster 5.8</strong> added a new and improved <a href="/docs/installation/security-ldap-active-directory/various-ldap-ldap-active-directory">LDAP and Active Directory integration</a>, which makes maintaining user and group permissions easier than before. Complex multi-domain active directory structures with multiple domains can now be set up easily, as our new integration allows you to define permissions in a third-party LDAP directory or in an active directory domain forest. If you choose to use an active directory domain, you can also enable built-in Windows Integrated Authentication, which eliminates the web-based login prompt.</p><p>The optional new "LDAP and Active Directory" user directory is served from the InedoCore extension (v5.8.0+) and bundled with the installer. The current user directory settings are not changed and require additional configuration within BuildMaster to use them. Refer to the <a href="/docs/installation/security-ldap-active-directory/various-ldap-ldap-active-directory?highlight=%20buildmaster-administration-ldap">LDAP and Active Directory documentation</a> for configuration options and, if necessary, troubleshooting steps.</p><h2 id="plan-versioning">New Feature: Plan Versioning</h2><p><strong>BuildMaster 5.8</strong> added <a href="/docs/buildmaster/deployment-continuous-delivery/buildmaster-deployment-scripts#versioning">Plan Versioning</a>, where a history of edits is kept within BuildMaster; this allows approved team members to view the version history or even roll back to a previous version. You can also easily view the differences between the two versions on the Plan Version Listing page. The differences between the two selected plans are highlighted so that the changes made can be quickly identified.</p><h2 id="sdk-changes">SDK Changes</h2><p><strong>BuildMaster 5.0&nbsp;</strong>and<strong>&nbsp;BuildMaster 5.1</strong> shipped with a new SDK with breaking changes. This means extensions 5.0 extensions will not work with any version except 5.0, however, 5.1 will work with later versions.</p><p><strong>BuildMaster 5.2</strong> through <strong>BuildMaster 5.7</strong> shipped with a new SDK, but all additive changes.</p><p>Although the SDK is mostly the same (even from v4), the notable changes are as follows.</p><ul><li><strong>Operations</strong> are the v5-equivalent of Actions. However, you do not need to develop an Operation to use these in OtterScript plans, thanks to the special <a href="/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-features/buildmaster-legacy-plans#legacy-actions">Execute-LegacyAction</a> operation.</li><li>StoredProcs to DB - the utility class that provided access to the database API is now called DB. This new class is much more performant, supports transactions, has better type safety, and supports asynchronous queries. In nearly all cases, simply renaming StoredProcs to DB will be sufficient.</li><li><a href="https://sdkdocs.inedo.com/sdk/buildmaster/5.1">5.1+</a> Agent service interfaces were moved into the <code>Inedo.Agents</code> namespace in the <code>Inedo.Agents.Client</code> assembly</li><li><a href="https://sdkdocs.inedo.com/sdk/buildmaster/5.1">5.1+</a> <code>IRemoteZip</code> has been included, its two methods folded into <code>IFileOperationsExecuter</code></li><li><a href="https://sdkdocs.inedo.com/sdk/buildmaster/5.2">5.2+</a> The <code>VariableFunctionPropertiesAttribute</code> was obsoleted in the BuildMaster 5.2 SDK. If you have a custom variable function and wish to compile against this SDK, use them <code>LegacyAliasAttribute</code> instead of the <code>LegacyAlias</code> property, and a <code>TagAttribute</code> instead of the <code>Category</code> property. The <code>Scope</code> property was ignored since v5.</li><li><a href="https://sdkdocs.inedo.com/sdk/buildmaster/5.5.0">5.5+</a> The SDK changes are additive, to support additional dynamic list variables features. If you have a custom editor that inherits from <code>PromotionRequirementEditorBase</code>, that will no longer be displayed in the UI. It needs to be refactored to use <code>PromotionRequirementEditor</code> or the appropriate editor attributes.</li></ul><p>See the Writing a Simple Operation Using the BuildMaster SDK tutorial and the <a href="https://sdkdocs.inedo.com/sdk/buildmaster">BuildMaster SDK Reference</a> for more details.</p><h2 id="extensions-changes">Extensions Changes</h2><p>The following extensions are supported in BuildMaster v5. Extensions with an asterisk (*) have actions that have not yet been converted to operations, though they will still function fine in an OtterScript plan using the <a href="/docs/buildmaster/installation-maintenance/buildmaster-legacy/buildmaster-legacy-features/buildmaster-legacy-plans#legacy-actions">Execute-LegacyAction</a> operation.</p><div class="attention best-practice"><section class="infoBox"><div class="title">Supported in v5:</div><div class="content">Amazon*, Azure*, Git, GitHub, Jenkins*, Jira, Java*, Mercurial, MSTest, MySQL, NuGet, Oracle, Perforce, PostgreSQL, Sourcegear, SqlServer, Subversion, TeamCity*, TFS*, Trac, Windows, WindowsSDK, YouTrack</div></section></div><p>Note that the JUnit extension was merged with the Java extension.</p><h4 id="un-migrated-extens">Un-migrated Community Extensions</h4><p>Some of the extensions developed by and for the community have not been updated to the new SDK and therefore will not work in v5. Although it is trivial to recompile/republish them, many of these extensions do not meet our usability/quality standards or do not support newer versions of the tool they're integrating with. Therefore, we would prefer to work with a user familiar with the tool to bring it up to date.</p><section class="warningBox"><div class="title">Not Currently Supported in v5:</div><div class="content"><p class="announcement">AccuRev, Artifactory, Axosoft, BugTrackerNet, Bugzilla, CollabNet, CVS, DB2, FogBugz, FTP, LeanKit, MBUnit, PHPUnit, Plastic, Rake, Rational, Seapine, Skytap, VB6, WiX</p></div></section><p>If you are using any of these extensions, just <a href="https://inedo.com/company/contact">let us know</a> and we will recompile and publish them to work for v5.</p><h4 id="50-extensions">BuildMaster 5.0: All Extensions Must be Upgraded</h4><p>Because the breaking SDK changes from v4, you will need to upgrade all of your extensions after you upgrade BuildMaster. This is quite easy from the Admin &gt; Extensions page.</p><h4 id="51-extensions">BuildMaster 5.1: All Extensions Must be Upgraded</h4><p>Because the breaking SDK changes from 5.0, you will need to upgrade all of your extensions after you upgrade BuildMaster. This is quite easy from the Admin &gt; Extensions page.</p><h4 id="53-extensions">BuildMaster 5.3: Core Functionality Moved to BuildMasterCore Extension</h4><p>Most operations and variable functions have been moved to the built-in extensions; if nothing works after the upgrade, then most likely the extensions could not be loaded due to permissions errors. However, once the extensions are loaded, there is no functional difference.</p><h4 id="56-extensions">BuildMaster 5.6: GitLegacy and GitHubLegacy Extensions</h4><p>This largest upgrade impact will be for users with the <strong>Git</strong> and <strong>GitHub</strong> extensions. Users with these extensions <strong>must download the GitLegacy and GitHubLegacy extensions</strong> to maintain existing functionality. This may occur post-upgrade via the Extensions Overview page within BuildMaster, or by visiting the Inedo Den and downloading directly at http://inedo.com/den</p><h4 id="57-extensions">BuildMaster 5.7: New Extension Loader</h4><p>The extensions loader has changed since v5.6 for parity with Otter's romp extension loader. There should be no observable functional changes as extension load paths and temporary paths are the same.</p>