---
title: "Upgrading ProGet"
order: 5
url-slug: "proget-upgrade-guide"
---

ProGet is self-managed, which means you can control when and how often you want to upgrade. When planning an upgrade for your ProGet instance, there are two categories of releases to consider:

* **Maintenance releases** are low-risk and contain only backward-compatible enhancements, bug fixes, and security patches; we recommend upgrading to the latest maintenance release at least once per quarter
* **Major releases** typically implement a brand new feature or revise an existing feature and are inherently higher risk than a maintenance release; we recommend reading the release notes carefully before planning to upgrade

See [When should I upgrade my Inedo Product?](/docs/installation/upgrading#when-should-i-upgrade-my-inedo-product) to learn more.

## ProGet Upgrade Path
You can see which version of ProGet you're currently using in the bottom right corner of the ProGet web application.

| Current Version | Upgrade Path |
| --- | --- 
| ProGet&nbsp;2024.\* | *This is the current release, and you should perform regular maintenance upgrades to stay up to date.*
| ProGet&nbsp;2023.\*<br />ProGet&nbsp;2022.\*<br />ProGet 6.0.\*<br/>ProGet 5.3.\*  | Upgrade directly to the latest ProGet 2024 ([see notes](/docs/proget-upgrade-2024))
| ProGet 5.2.\*<br />ProGet 5.1.\* <br /> ProGet 5.0.\*<br />ProGet 4.\*.\* | Upgrade to latest ProGet 5.2, then latest ProGet 2023<br/>See: [5.2 notes](/docs/proget/installation/proget-upgrade-guide/proget-installation-and-maintenance-and-upgrade-notes-upgrading-to-proget-5-2)
| ProGet 3.\*.\* <br />ProGet 2.\*.\*<br />ProGet 1.\*.\* | Upgrade possible, but consider retiring and starting over<br/>See [v2/v3 notes](/docs/proget/installation/proget-upgrade-guide/proget-installation-and-maintenance-and-upgrade-notes-upgrading-from-proget-v2-and-v3)


## How to Upgrade ProGet

The method you use to upgrade ProGet depends on [how you installed ProGet](/docs/proget/installation/installation-guide). However, we recommend [performing a back-up](/docs/installation/backing-up-restoring), just in case something goes wrong and you need to roll back. This is especially important if you are performing a major upgrade.

### Windows Servers (Inedo Hub)
If you installed ProGet on Windows using the [Inedo Hub](/docs/installation/windows/desktophub-overview), it's a really easy process.

![Inedo Hub](/resources/docs/Inedo%20Hub%20Home%202.png)

Simply click "Upgrade" next to ProGet, select the desired version, and click Install. See [HOWTO: Upgrade or Downgrade with the Inedo Hub](/docs/installation/windows/inedo-hub-upgrade-downgrade) to learn more.

### Linux Servers (Docker)

If you installed ProGet on Linux, you can follow our [upgrading your Docker containers guide](/docs/installation/linux/installation-upgrading-docker-containers) to learn more.
