---
title: "Chocolatey Feeds in ProGet"
nav-title: "Chocolatey (Windows/Machine)"
order: 5
---

[Chocolatey](https://chocolatey.org/) is a package manager for Windows. Similar to Linux tools like apt or yum, but designed specifically for Windows, Chocolatey is designed as a decentralized framework for quickly installing applications and tools you need.

Proget lets you create ["Feeds"](/docs/proget/feeds/feed-overview) that can be used to proxy packages from Chocolatey.org, or host your own internal packages. 

## Integrating Chocolatey with ProGet

Before installing Chocolatey packages from ProGet, you will need to add ProGet as a source using the `choco source add` command. We recommend giving the source the same name as your feed:

```bash
$ choco source add -n="«feed-name»" -s="https://«proget-server»/feeds/«feed-name»" --priority=1 
```

To make sure that your client only installs Chocolatey Packages from ProGet, we recommend removing any default sources already configured using the `choco source remove` command:

```bash
$ choco source remove -n="chocolatey"
```

### Testing Client Configuration

You can use the `choco source list` to make sure that your client is properly connected to ProGet.

```bash
$ choco source list
```

## Installing Packages

To install Chocolatey packages from ProGet, you can use the `choco install` command:

```bash
$ choco install «package-name» --version «version-name» --source «feed-name»
```

Using `«feed-name»` as a source assumes this is the name you assigned it when configuring ProGet as a source as a prerequisite. 

## Authenticating to a Chocolatey Feed

By default, Chocolatey feeds in ProGet do not require authentication and can be viewed anonymously. However, you can set a feed to require authentication to access. This will be required to push Chocolatey packages to ProGet.  

:::(info) (Authenticating with an API Key)
Rather than use your ProGet username and password, we strongly recommend using an API key for this, with `api` as the username, and then API Key as the password. You can read more about creating one on our [API Key](/docs/proget/reference-api/proget-apikeys) page. 
:::

When creating an API Key, fill in the fields by selecting "Feeds ("Use Certain Feeds)" as the "Feed Type" and selecting the Chocolatey feed to authenticate to. Make sure that the required permission boxes are checked, and then select "Save".

![](/resources/docs/proget-chocolatey-apikey.png){height="" width="50%"}

Then when adding ProGet as a source using `choco source add`, include the API key as a parameter:

```bash
$ choco source add -n="«feed-name»" -s="https://«proget-server»/feeds/«feed-name»" --user=api --password=«api-key»
```

## Creating and Pushing Packages

There are several ways to create Chocolatey packages like the Chocolatey CLI or manually create `.nuspec` files, following the guidelines in the [Chocolatey documentation](https://docs.chocolatey.org/en-us/create/).

Many users find the simplest method for publishing packages is by using [pgutil](/docs/proget/reference-api/proget-pgutil). While this does require some [minor configuration](/docs/proget/reference-api/proget-pgutil#sources) beforehand, it allows you to more easily specify different feeds.

:::(info) (Example:)
To upload the package `My.Package.1.0.0.nupkg` stored at `C:\chocolatey-packages\MyPackage\` to your `internal-chocolatey` feed you would enter:

```bash
$ pgutil packages upload --feed=internal-chocolatey --input-file=C:\chocolatey-packages\MyPackage\MyPackage.1.0.0.nupkg
```
:::

Your package will then be uploaded to the `internal-chocolatey` feed. To learn more about creating and publishing Chocolatey packages, see [HOWTO: Create and Push Chocolatey Packages to a Private Repository in ProGet](/docs/proget/feeds/chocolatey/howto-chocolatey-publish).

## Internalizing Chocolatey Packages

If you want to minimizing reliance on external sources for software installed using Chocolatey Packages, you can internalize your packages. Chocolatey’s [package internalizer](https://docs.chocolatey.org/en-us/features/package-internalizer) can internalize packages automatically or you can do it yourself. 

To learn more on how to do this you can read [HOWTO: Set Up a Private Chocolatey Repository for Internalized Packages](/docs/proget/feeds/chocolatey/howto-chocolatey-internalized#internalize-packages)

## Differences Between Chocolatey Feeds and NuGet Feeds in ProGet

As the Chocolatey API is built on top of the NuGet v2 API, a Chocolatey feed in ProGet is actually a [NuGet feed](/docs/proget/feeds/nuget) with some slight differences in behavior:
* Packages in Chocolatey feeds have a different icon to indicate that they are intended for use by Chocolatey
* The package installation instructions also include an example of installing the package using `choco` instead of NuGet
* The [Package Usage feature](/docs/proget/feeds/chocolatey/howto-chocolatey-scan) is `enabled`, while the Package Consumers feature is `disabled`
* [Internalized packages](/docs/proget/feeds/chocolatey/howto-chocolatey-internalized) can be hosted in Chocolatey feeds 

## ProGet + Chocolatey Webinar

In the following video, Chocolatey founder Rob Reynolds presents a demo of ProGet and Chocolatey, showing how the two combine to form a complete Windows package management solution.

ProGet's user interface has been updated since this video, but the instructions provided are still valid.

<iframe width="600" height="337" src="https://www.youtube.com/embed/BcTYGf7sQ8Q" frameborder="0" allowfullscreen="true"></iframe>
