---
title: "パッケージダウンロード統計"
order: 3
hidden: true
---

ProGet の**パッケージダウンロード統計**機能を使えば、パッケージのダウンロード履歴を個別にトラッキングできます。この統計機能をオンにすると、ProGet がパッケージのダウンロード日時や、ユーザー名、その他のパッケージ情報などを記録します。

これにより、ダウンロード頻度が低いパッケージの開発優先度を下げたり、逆にダウンロード頻度が高いパッケージの改善と脆弱性チェックに、より多くの時間を割くなど、データドリブンな意思決定が可能になります。

また、意思決定のための統計データだけではなく、パッケージに問題がある場合、問題を解決するために誰に連絡すればよいかをより迅速に把握できたり、開発者が望ましくないパッケージをダウンロードした場合、問題を解決するために具体的に誰をトレーニングする必要があるかを確認できるなど、日々の業務の時間節約にもなります。

パッケージのダウンロード履歴はどの ProGet のバージョンでも記録できますが、日付、ユーザー名やその他の情報は有料版もしくは無料体験版でしか確認できないのでご注意ください。

## パッケージダウンロード統計の設定方法
パッケージダウンロードの統計データは、多くのディスクスペースを使用する可能性があります。また、ダウンロード統計が必要ではないフィードもあるでしょう。そのため、ProGet はディスクスペースを効果的に使用できるよう、フィード毎にダウンロードをトラッキングするかを設定できます。

[Manage Feed (フィードの管理)] > [Properties (プロパティ)] > [Package Statistics (パッケージ統計情報)] から設定してください。[Record individual downloads for advanced statistics (個別のダウンロードを記録して詳しい統計を許可する)] を有効にできます。

さらに、IP アドレスなどの機密情報の閲覧を制限したい場合は [Restrict viewing download statistics to Feed Administrators (フィード管理をするユーザーのダウンロード統計の閲覧を制限する)] こともできます。

## UI（ユーザーインターフェイス）からパッケージダウンロードの統計を閲覧する

ダウンロード統計機能がオンになると、パッケージファイルの要求がある度に ProGet が以下の情報を記録するようになります。

* **ユーザネーム** – パッケージをダウンロードした認証済みのユーザー名、もしくは未ログインの場合は「匿名」
* **IP アドレス** – パッケージリクエスト時のIPアドレス
* **ユーザ エージェント** – ダウンロード要求内のユーザ エージェントのヘッダー
* **日付/時間** – ダウンロードの日時

![ProGet_usage-and-stats_tab](/resources/docs/ProGet_usage-and-stats_tab.png){height="" width=""}

## 無料版ではできないこと
ProGet の無料版では、この機能をプレビューまたは手動で体験できます。

実際のダウンロード情報も記録されますが、無料ユーザーは日付、ユーザー名、IPアドレスが非公開になっています。

有料版のProGetで見られる記録を表示するには、IPアドレス127.0.0.* (1以外)を使って[add record (記録を追加)]から記録を手動で入力してください：

## 詳細なレポート
直接ProGetのSQLサーバ（データベース）をクエリしたり、データのエキスポートをしたりすれば、パッケージダウンロードについてより詳細な分析をご覧になれます。それぞれのダウンロード記録は[PackageDownloads]テーブルに蓄積されています。

例えば、以下のクエリで[RubbishSoft.LongGUID]という名前のパッケージを過去90日間の間にダウンロードしたユーザーを特定できます。