---
title: "Asset Directory API"
order: 10
---

The Asset Directory API provides several pgutil commands (available as `pgutil assets`) and HTTP endpoints to query, download, publish, delete, and perform other operations on files and folders in an asset directory. All HTTP requests are made through the following base URL:

:::(info)
 `/endpoints/«AssetDirectoryName»/...`
:::

Asset Directories are represented internally in ProGet as Feeds, so [Feed API keys](/docs/proget/administration-security#api-keys) can be used to authenticate to Asset Directories.

## pgutil Commands

All HTTP endpoints of the The Asset Directory API are available as `pgutil` commands. 

To find the list of commands available in `pgutil`, simply run `pgutil assets`. See [Getting started with pgutil](/docs/proget/reference-api/proget-pgutil) to learn more.

## Available HTTP Endpoints

The Asset Directory API is comprised of endpoints for both files and folders:

### 📄 File Management { #file-endpoints }

For directly managing the files located in the asset directory. They are designed to function like a standard web server, so hosted files can be accessed by simple GET requests with support for browser caching. 

* [Download Asset File](/docs/proget/reference-api/proget-api-assets/file-endpoints/proget-api-assets-files-download) - returns the content of a specified file or the files's headers
* [Upload Asset File](/docs/proget/reference-api/proget-api-assets/file-endpoints/proget-api-assets-files-upload) - uploads a specified file to the asset directory
* [Delete Asset File](/docs/proget/reference-api/proget-api-assets/file-endpoints/proget-api-assets-files-delete) - deletes a specified file from the asset directory

### 📁 Folder Management { #folder-endpoints }

For managing the folders located in the asset directory.

* [List Asset Folder](/docs/proget/reference-api/proget-api-assets/folder-endpoints/proget-api-assets-folders-list) - describes assets in a specified folder
* [Create Asset Folder](/docs/proget/reference-api/proget-api-assets/folder-endpoints/proget-api-assets-folders-create) - creates a new subfolder
* [Delete Asset Folder](/docs/proget/reference-api/proget-api-assets/folder-endpoints/proget-api-assets-folders-delete) - deletes a specified subfolder
* [Export Asset Folder](/docs/proget/reference-api/proget-api-assets/folder-endpoints/proget-api-assets-folders-export) - exports the contents of a folder as either a `ZIP` or a `TGZ` archive
* [Import Archive](/docs/proget/reference-api/proget-api-assets/folder-endpoints/proget-api-assets-folders-import) - imports the contents of either a `ZIP` or a `TGZ` archive as a subfolder

### 🔖 Metadata Management { #metadata-endpoints }

Allow for reading or updating metadata on a file or folder. Added in ProGet v6.0.0.

* [Get Asset Metadata](/docs/proget/reference-api/proget-api-assets/metadata-endpoints/proget-api-assets-metadata-get) - describes the metadata for the specified file or folder
* [Set Asset Metadata](/docs/proget/reference-api/proget-api-assets/metadata-endpoints/proget-api-assets-metadata-set) - sets/updates the `Content-Type` or user-defined metadata of a file or folder.

## Authenticating to Asset Directory API { #authentication }

The following is a summary of access types and their corresponding requirements for various API keys types and endpoints within this API.

| Access Type | Requirements |
| --- | --- |
| System API Keys | `Use/Manage Feeds`  
| Feed API Keys | `View/Download` is required for all endpoints<br/>`Add/Repackage` is required for uploading/importing<br/>`Overwrite/Delete` is required for deletion
| Personal API Key | `Feeds_ViewFeed` is required for all endpoints<br/>`Feeds_AddPackage` is required for uploading/importing<br/>`Feeds_DeletePackage` is required for deletion
| No API Key | anonymous or authenticated user must have at least `Feeds_ViewFeed`

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the username. See [API Key Usage](/docs/proget/reference-api/proget-apikeys#using-api-keys) to learn more.

:::(Info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `abc12345` to **List Asset Folders**, you could specify the API key as follows:
````
curl -X GET --header "X-ApiKey: abc12345" "https://proget.corp.local/endpoints/internal-files/dir/"
````
:::

## Data Specifications { #data-specifications }

### AssetDirectoryItem Object Attributes { #item-data }

`AssetDirectoryItem` is a JSON object (see [AssetDirectoryItem.cs](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/AssetDirectories/AssetDirectoryItem.cs)) that corresponds to the properties an "item" (either a file or folder) within the Asset Directory. It's used as output data for [List Asset Folder](/docs/proget/reference-api/proget-api-assets/folder-endpoints/proget-api-assets-folders-list) and [Get Asset Metadata](/docs/proget/reference-api/proget-api-assets/metadata-endpoints/proget-api-assets-metadata-get).

#### JSON Object Example:

```
{
  "name": "example.txt",
  "parent": "/documents",
  "type": "text/plain",
  "content": "https://proget.corp.local/endpoints/myAssetDirectory/content/documents/example.txt",
  "created": "2023-11-29T09:45:00",
  "modified": "2023-11-29T10:30:00",
  "size": 1024,
  "sha1": "a1b2c3d4e5f6g7h8i9j0"
}
```

### AssetItemMetadataUpdate Object Attributes { #metadata-update }

`AssetItemMetadataUpdate` is a JSON object (see [AssetItemMetadataUpdate.cs](https://github.com/Inedo/pgutil/blob/thousand/Inedo.ProGet/AssetDirectories/AssetItemMetadataUpdate.cs)) that correspond to the fields in a metadata update. It's used as input data for [Set Asset Metadata](/docs/proget/reference-api/proget-api-assets/metadata-endpoints/proget-api-assets-metadata-set) 

#### JSON Object Example

```
{
  "type": "application/json",
  "userMetadata": 
        {
         userMetadata // userMetaData Object
        },
  "userMetadataUpdateMode": "update",
  "cacheHeader": 
      {
        "type": "TTL",
        "value": 60
      }
}
```