---
title: "Build Reports"
order: 2
---

Build reports are used to attach some form of generated text output with a specific [build](/docs/buildmaster/builds-continuous-integration/buildmaster-builds) in order to display the output directly on the Build Overview page. Typical use cases for a build report are:

*   Diff comparison report between two sets of files on disk
*   Diff comparison of most-recent artifact contents vs. previously-captured artifact contents
*   Displaying a file generated by a third-party tool

As an implementation detail, build reports are associated with an execution, therefore if a build deployment is re-executed (or executed in a different stage), captured reports of the same name will overwrite the existing report.

:::(Info) (Note:)
 Build reports are not persisted by [application backup/restore](/docs/buildmaster/modeling-your-applications/buildmaster-applications-concepts/buildmaster-applications-concepts-backup-restore). To maintain important information across this boundary, use build artifacts instead.
:::

## Capturing Build Reports

Build reports are captured using one of the following operations:

#### `Capture-HtmlDirectoryReport`

An HTML directory report requires a specific format to be displayed correctly within BuildMaster. At minimum, the directory must contain an index file (typically index.html) that provides `<a>` links relative to the captured directory.

This operation also allows an optional preview file to be displayed on the build overview page.

#### `Capture-FileReport`

A file report is displayed as either plain text or HTML, depending on the format specified in the operation. By default, a file is assumed to be HTML if it begins with a `<` angle bracket.

## Generating Reports

Generating reports are accomplished using one of the two built-in operations below, or by running a third-party tool and capturing the output.

#### `Compare-Directories`

This operation compares two directories on the same server and highlights the following information:

*   Added files or directories
*   Deleted files or directories
*   Modified file contents

#### `Compare-Artifacts`

This operation works in the same manner as the Compare-Directories operation, with the following caveats:

*   Artifacts are extracted and compared on the BuildMaster server
*   Build scope – indicates that artifacts from the current build and the build immediately prior are to be compared
*   Release scope – indicates that artifacts from the current build and the deployed build of the release one lower by sequence number are to be compared

### Custom Build Reports

To capture and associate a custom build report, simply run a third-party tool with the `[Exec](/docs/buildmaster/reference/operations/general/execute-process)` operation then capture its output with one of the two built-in [capturing operations](#capturing-reports).

#### Examples

**Simple plain text report**
    
    {
        Create-File example.txt
        (
            Text: Hello from BuildMaster v$ReleaseNumber.$BuildNumber on $Date!
        );
    
        Capture-FileReport example.txt
        (
            Name: Plain Text Report
        );
    } The following example generates and captures an HTML directory report:

  
**HTML Directory Report**

    {
        Create-File index.html
        (
            Text: >1><html>
            <head>
            </head>
            <body>
            <h1>Captured Report - Home</h1>
            <p>
            <a href="other.html">Link to Other page</a>
            </p>
            </body>
            </html>>1>
        );
    
        Create-File other.html
        (
            Text: >2><html>
            <head>
            </head>
            <body>
            <h1>Captured Report - Other Page</h1>
            <p>
            <a href="index.html">Link back to home page</a>
            </p>
            </body>
            </html>
            >2>
        );
    
        Create-File preview.html
        (
            Text: >3><html>
            <head>
            </head>
            <body>
            <h1>Preview</h1>
            <p>
            This preview is displayed on the Build Overview page.
            </p>
            </body>
            </html>
            >3>
        );
    
        Capture-HtmlDirectoryReport
        (
            Name: Beyond Compare Report,
            Index: index.html,
            Preview: preview.html
        );
    } 

### Example: Third-party Report Generation

Below is an example of generating a report from a third-party tool [Beyond Compare](https://www.scootersoftware.com/). It assumes the command line utility is installed on the server.

Beyond Compare is a multi-platform utility that combines directory compare and file compare functions in one package. While typically used as a GUI tool, it also ships with a [command line utility](https://www.scootersoftware.com/v4help/index.html?command_line_reference.html) that can be used to generate diff reports from an automated system like BuildMaster.

**Example plan:**

    # Run Beyond Compare and capture output into a build report
    {
        # set variables here for example simplicity
    
        set $PrevDirectory = C:\tmp\reports\prev; 
        set $CurrDirectory = C:\tmp\reports\curr;
    
        set $ScriptPath = $PathCombine($WorkingDirectory, script.txt);
        set $ReportPath = $PathCombine($WorkingDirectory, report.html);
    
        Create-File $ScriptPath
        (
            Text: >>load "%1" "%2"
    expand all
    folder-report layout:side-by-side &
    options:display-all &
    output-to:%3 output-options:html-color>>
        );
    
        Exec '"C:\Program Files (x86)\Beyond Compare 3\BCompare.exe" "`@$ScriptPath" "$PrevDirectory" "$CurrDirectory" "$ReportPath" /silent';
    
        Capture-FileReport $ReportPath
        (
            Name: Beyond Compare Report
        );
    }
    

This generates the following output when viewed on the BuildMaster build overview page:

<!--
![](/resources/documentation/buildmaster/6/report-example.png)
 -->