---
title: "パッケージフィードとは"
order: 1
hidden: true
---

ProGetにおける「フィード」は、社内用のアプリストアのようなものです。 「フィード」は、レジストリ、リポジトリ、ディレクトリとも呼ばれます。 フィードは、社内のアプリケーション、コンポーネント、パッケージ、コンテナイメージの管理とダウンロードを簡単にします。

例えば、

* 複数のフィードを作成し、社内パッケージの開発工程（パイプライン）として活用
* フィード毎に、特定のユーザやグループに、アクセス、編集、管理権限や、タスクを割り当てる
* NuGet.orgなどのパブリックリポジトリと連携して、外部のパッケージを取り込む
* 取り込んだパッケージの脆弱性を自動でスキャンする
* フィード内に外部パッケージのキャッシュを作成する
* リテンションを設定し、ストレージスペースを節約する
などです。

この記事では、フィードの作成方法から、管理、その他の機能から、削除までを紹介します。

## フィードの作成と管理
新しいフィードを作成するには、 

[フィード] >  [新しいフィードの作成] 

に移動します 。
[フィード] ページ、またはフィードページに移動して [フィードの管理] ボタンをクリックし、フィードの管理もできます。

## フィード名
すべてのフィードには、API アクセスに使用される「APIエンドポイント」URLがあり、フィードの名前は、このエンドポイントURLの一部になります。フィードの名前には、英数字やハイフンなど、URL に適した文字のみを使用できます。フィードのURLは、フィードの参照ページの右上隅にあります。

フィードの名前を変更すると、APIエンドポイントURLも変更されます。ProGet 5.2.19以降は、[フィードの管理] > [名前の変更] に移動し、警告ダイアログの [代替名の設定] リンクをクリックして、フィードの「代替名」を作成できます。

フィードの代替名は、フィードに複数のエンドポイント URL を提供し、古い名前との下位互換性を維持するために、フィードの名前を変更するときに役立ちます。

## フィードの種類と使用法
フィードを作成したら、フィードのタイプを指定します。フィードのタイプを指定したら、以下の2つが固定されます。

* フィードが使用するパッケージのタイプ：たとえば、NuGet フィードは NuGet パッケージのみを保存し、npm フィードは npm パッケージのみを保存します。
* フィード内のパッケージにアクセスするための API：たとえば、ユニバーサルフィードはユニバーサルフィード API のみを使用し、NuGet フィードは NuGet API のみを使用します。

また、一部のフィードには、特殊なオプションがあります。

* **NuGetパッケージタイプ** ：Chocolatey と PowerShellGet はどちらも NuGet パッケージを使用します。パッケージタイプを変更することで、フィード全体の外観を変更できます。
* **フィードの利用統計** ：この機能は ProGet 5.3 以降で使用できます。
* **フリーまたはオープンソースのパッケージ**： パブリックリポジトリからのソースパッケージのキャッシュとフィルタリング、脆弱性のスキャン、ライセンスの確認など。
* **プライベートまたは社内パッケージ**： 社内で使用するために作成したプライベートなパッケージを共有する
* **検証済みパッケージ**：社内の品質基準を満たし、本番環境での使用に適したパッケージ。
* **混合パッケージ**：サードパーティのパッケージと、社内パッケージの両方をホストする。混合パッケージの利用は基本的に推奨していません。これは、ライセンスフィルタリングなど、社内パッケージには不要な機能があるからです。

## 複数のフィードの作成する
複数のフィードを使用する主な利点は、 パッケージの整理です。理論的には、すべてを1つのフィードにまとめることができますが、100 を超えるパッケージの様々なバージョンを1つのフィードで管理することは困難です。

複数のパッケージフィードを作成すれば、パッケージを様々な方法で整理できます。たとえば、フィードを使用するチームごとに、フィードをセグメント化できます。これにより、チームは、必要なパッケージのみに集中できます。

品質（新規、テスト済み、本番用など）ごとに整理もできます。セキュリティやストレージなどの構成も、フィードの整理方法を決定する要因になるでしょう。ProGet では、フィードに セキュリティとアクセス制御を設定し、ユーザーやチーム毎に、各フィードにたいする権限（閲覧、編集、管理など）を設定できます。たとえば、リードエンジニアだけがパッケージをプロダクションフィードに公開できるように設定できます。

## コネクタとレプリケーション

コネクタを使用すると、ProGet フィードに外部ソースからのパッケージをまとめられます。外部のパッケージソースには、NuGet.org や、別の ProGet フィードなど、あらゆるパッケージ API URL が含まれます。

集めたパッケージは、ライセンスや脆弱性でフィルターしたり、「承認済み」フィードに移動したりできます。ProGet のすべてのバージョンでコネクタを使用できるため、ProGet は NuGet などのパブリックフィードの理想的な社内用プロキシサーバーになります。

無料バージョンの ProGet ではコネクタフィルターが制限されています。また、ProGetインスタンス間の接続は ProGet EULA に違反します。

フィードの複製は ProGet エンタープライズ版の機能です。世界中のさまざまな ProGet インスタンス間でパッケージを複製して、複雑なグローバルインフラストラクチャを設定することなく、さまざまなチームがフィードを共有できるようにします。

## フォルダとまとめてパッケージをインポート
場合によっては、ユーザーまたはプログラムが、そのフィードタイプの API を使用して ProGet に公開するよりも、パッケージファイルをネットワークドライブにコピーする方が簡単な場合があります。例えば、パッケージの一括インポートです。

フィードで「ドロップフォルダ」を設定すると、ProGet が定期的に指定したフォルダをスキャンし、ProGet がサポートしているファイルを見つけて自動でインポートします。

デフォルトでは、既存のパッケージは上書きされませんが、 [管理] > [詳細設定] に移動し 、 [Feeds.AllowDropPathImportOverwrite] を [true] に変更すると、上書きできます。

## パッケージファイルのストレージとリテンション
デフォルトの設定では、フィードのパッケージファイルは、ProGet が管理するディレクトリに保存されます。このディレクトリを変更するには、デフォルトのディレクトリを編集するか、フィードの [ディレクトリ] プロパティを設定します。

Amazon S3とAzure Blob パッケージストレージで、クラウドストレージを使用するには、別のパッケージ保存先を設定する必要があります。この機能は、無料バージョンのProGetでは使用できません。

## リテンションポリシー
リテンションポリシーは、フィード毎に設定できます。この機能を使えば、自分で設定した基準を満たす古いパッケージや、使用されていないパッケージを自動で削除し、ディスク領域を節約できます。詳細は、 リテンションポリシーを参照してください。

## パッケージのストレージ
ファイルのバックアップ以外の理由でパッケージファイルに直接アクセスすることはサポートされていません。ProGetの将来のバージョンでは、パッケージファイルをディスクに保存する方法が変更される可能性があります。

フィードのデフォルトディレクトリは、次のパス要素を組み合わせて作成されます。

### ルートストレージパス
このパスは Storage.PackagesRootPath 設定（ [管理] > [詳細設定] ）で構成され、デフォルトは %ProGramData%\ProGet\PackagesRoot です。値は、[詳細設定] で割り当てるか、負荷分散インストールの場合は、インストールの .config ファイル（web.config またはProGet.Service.config）でキー名 ProGetConfig.Storage.PackagesRootPath で設定できます。「.config」ファイルの値を使用するには、ここで指定した値を空の値で保存する必要があります。「.config」ファイルで構成すると、その値がここに表示されます。

### パッケージタイプパス
各フィードタイプは、異なる設定と異なるデフォルトを使用します。たとえば、npmフィードはStorage.NpmPackagesLibraryを使用します。デフォルトは.npmです。

### FeedId. 
フィードの不変の整数ベースの識別子

パッケージタイプパスが絶対パスの場合、ルートストレージパスは無視されます。たとえば、デフォルトの設定が変更されていない場合、IDが1のNuGetフィードは、次のパスにパッケージを格納します。

%ProgramData%\ProGet\PackagesRoot.NuGetv2\F1

## ディレクトリの変更
フィードのディスクディレクトリを直接（フィード設定ページに移動して）または間接的に（パスのデフォルトを編集して）変更しても、パッケージファイルは移動されません。

## ストレージアクセスと権限
ProGet Webアプリケーション（統合WebサーバーのINEDOPROGETWEBSVCサービスのログオンユーザー、またはProGet IISサイトに関連付けられたアプリケーションプールID）と INEDOPROGETSVC サービスのログオンユーザーの両方が、フィードのディスクディレクトリに対するフルコントロールのアクセス許可を持っている必要があります。

ネットワークストレージを使用する場合は、マップされたドライブ（p:\packages ）ではなく、UNCパス（例： \\filesv1\packages ）を使用します。

## フィード単位で設定できるProGetの機能
ProGetには、様々なフィード単位の機能があります。ここでは、その一部を紹介します

* Webhookを使用すると、ProGetを他のツールと統合してユーザーに通知したり、自動ワークフローをトリガーしたり、パッケージの作成や削除などのイベントを監査したりできます。たとえば、InedoのSlackチャネルには、ユーザーが新しい拡張機能、リリース、プレリリースを利用できるようになったときに通知するWebhookが含まれています。
* 脆弱性スキャンとブロック機能は、サードパーティパッケージとDockerコンテナイメージを、脆弱性データベースで自動的にスキャンできます。
* ライセンスの検出とブロックは、サードパーティのオープンソースパッケージのライセンス契約を管理するのに役立ちます。
* パッケージとコンテナのライブ使用状況スキャンは、OtterやKubernetesなどの外部リソースに接続して、インフラストラクチャ全体でパッケージとDockerコンテナイメージがどのように使用されるかを収集して表示できます。
* パッケージのデプロイトラッキング機能は、パッケージがデプロイされた場所を確認できます。
DLLパッケージのパッケージコンシューマーを表示して、特定のパッケージの、特定のバージョンを使用している他のパッケージやアプリケーションを確認します。