---
title: "Old Versions & Feature Migration"
order: 4
---

ProGet is constantly evolving with new and improved features. As self-managed software, we take great care in making sure that upgrades go smoothly and changes are clearly communicated in each release. This is why we have [detailed upgrade notes](/docs/proget-upgrade-guide) for major releases and [detailed change logs](https://my.inedo.com/downloads/issues) for maintenance releases,.

This article will give a "bigger picture" our releases, describe our feature design patterns, and provide guidance on how to migrate features across major releases.

## Feature Development & Release Cycle
As mentioned in [Upgrading your Inedo Product](/docs/installation/upgrading), we  ship "preview features" in maintenance releases. 

In many cases, preview features are intended to replace an existing feature or functionality. For example, [Project&nbsp;Releases](/docs/proget/sca/builds) was introduced as a preview feature in ProGet 6.0; it was designed to replace [Package Consumers](/docs/proget/installation/proget-old-versions-migration), and eventually did in ProGet 2022.

The main advantages to **Preview Feature** approach are:
* Early feedback on new features from users
* Test new functionality  "side-by-side" to make sure its on par with the old feature
* Verify data migration is accurate and correct
* Reduced risk when upgrading to the new feature

### Maintenance Releases: Feature Flags & Manual Data Migration
Preview features use a "feature flag" to determine how ProGet behaves.

The flag is often automatically enabled for new installations, but will require a manual enablement/migration for existing installations. Disabling the preview feature will usually delete data from the new feature.

For example, enabling Projects & Releases in ProGet 6.0 would migrate data from Package Consumers. The UI and API would then only use the new feature, and give error messages if you tried to use Package Consumers. Disabling Projects & Releases would delete the old data, thereby allowing users access to Package Consumers again.

### Major Releases: New Features & Automatic Migration

When it comes time for the major release, we will remove the feature flag, remove code for the old feature, and automatically migrate the data.

For example, when upgrading to ProGet 2022, all of the Package Consumer code was delete and the Package Consumer data was automatically copied to Projects & Releases. However, the old data was not deleted until ProGet 2023. This meant that you could downgrade to ProGet 6.0 from ProGet 2022 and use Package Consumers as needed.

## Feature Migrations Index

Whenever feasible, we will develop new features using the preview approach described above. However, this is not always realistic, especially when a data migration is complex. 

### Automatic Migration through Preview Features

When developed using the "preview feature" pattern, we will make the preview version of the feature available in one major version, delete the code in the next major version, and remove the data in the following major version.

This allows you to downgrade to one major version.

| Old → New Feature | Preview Available | Code Removal |Data Removal | 
| --- | --- | --- | --- |
| [Package Consumers (archive.org)](https://web.archive.org/web/20230723042121/https://docs.inedo.com/docs/proget-sca-package-consumers) <br/>→ [Project&nbsp;Releases](/docs/proget/sca/builds) | v6.0 |  v2022 | v2023  |
| [Project Releases](/docs/proget/sca/builds)<br/>→ [Projects & Builds](/docs/proget/sca/builds) | v2023 | v2024 | v2025 |
|  Package Access Rules (i.e. [WhiteSource](/docs/proget/installation/proget-old-versions-migration/proget-compliance-whitesource)) <br/>→ [Package Policies](/docs/buildmaster/administration/retention-policies) | v2023 | v2024 | v2025 | 
| Vulnerability Sources (i.e. [Clair](/docs/proget/installation/proget-old-versions-migration/proget-compliance-clair),  [OSS Index](/docs/proget/installation/proget-old-versions-migration/proget-compliance-ossindex))  <br/>→ [Built-in Vulnerability Scanning](/docs/proget/sca/vulnerabilities) | v2023 | v2024 | v2025 |
| "Old" Webhooks <br/> →  [Notifications & Webhooks](/docs/proget/administration/proget-notifications-webhooks) | v2023 | v2024 | v2025


### User-initiated Migration

In some cases, it's not feasible to automatically migrate data from one feature to another. In these cases, the upgrade will be blocked until you manually migrate.

| Feature Migration | First Available | Code Removal | Data Removal |
| --- | --- | --- | --- |
| [NuGet "Quirks" Feeds](/docs/proget/installation/proget-old-versions-migration/nuget-quirks)  <br/>→ [NuGet Feeds](/docs/proget/feeds/nuget#legacy-quirks-nuget-feeds) | v5.0 | v5.3 | v5.3 | 
| [Feed Replication (v6)](https://web.archive.org/web/20231210002734/https:/docs.inedo.com/v1/docs/proget-feed-replication-v6) <br/>→ [Feed Replication](/docs/proget/replication-feed-mirroring/proget-advanced-feed-replication) | v6.0 | v2022 | v2027
| "Old" Feed Indexes<br/>→ "New" Feed Indexes | v2023 |  v2023 | v2028
| [Debian (Legacy) Feeds](/docs/proget/feeds/debian)  <br/>→ [Debian Feeds](/docs/proget/feeds/debian) | v2023 | v2028 | v2028

The future-dated data removals are tentative, but upgrades to those versions will be blocked by the installer. For example, if you tried to upgrade from v4.3 to v5.3 with NuGet "Quirks" Feeds, the installer would error and not permit the upgrade.