---
title: "RPM (Yum)"
order: 15
---

[RPM Package Manager](https://rpm.org/) (RPM, originally Red Hat Package Manager), is a free, open-source package management system used by many Linux distributions including Red Hat and CentOS. RPM packages can be hosted and installed from ProGet.

## Prerequisite Configuration

In order to install packages from ProGet, each client must perform the following steps:

### Add a .repo file to `/etc/yum.repos.d`

Yum stores its repository configuration in .repo files located in `/etc/yum.repos.d/`. To register a ProGet feed as a repository, create a new `«repo-name»`.repo file in that directory with content:

```bash
[«repo-name»]
name=«repo-name»
baseurl=http://«proget-url»/rpm/«feed-name»/
gpgcheck=0
enabled=1
```

Note that `«repo-name»` can be anything, but we recommend using the ProGet feed name for clarity.

### Verify yum configuration

To verify that Yum is able to download package metadata, execute:

```bash
$ yum repolist all
```

If the configuration is correct, this will list all repos (including the ProGet feed registered in Step 1).

## Installing Packages

RPM packages are installed using Yum. To install a package hosted by ProGet, use the command:

```bash
yum install «package-name»
```

## Creating and Publishing Packages

To learn how to create and publish an RPM package to ProGet, see our guide on [HOWTO: Publish RPM Packages to a Private Repository in ProGet](/docs/proget/feeds/rpm/howto-rpm-publish).

## Connectors for RPM (Yum) Feeds

Starting in ProGet 2023.22, RPM (Yum) feeds support connectors to other ProGet RPM (Yum) feeds, official RPM repositories, and other third-party repositories.

When connecting to an official RPM repository, ProGet will periodically download the index file. To add a connector, follow our guide on [HOWTO: Aggregate RPM Repositories in ProGet](/docs/proget/feeds/rpm/howto-rpm-proxy#step-2)

When creating a connector to an official repository, we recommend using a name that follows the URL conventions. For example:

<table>
    <tr><td>URL:</td><td><code>https://mirror.stream.centos.org/9-stream/BaseOS/x86_64/os/</code></td></tr>
    <tr><td>Connector name:</td><td><code>centos-9-stream-baseos-x86_64-os</code></td></tr>
</table>

You can see a list of the default repositories in the `/etc/yum.repos.d/` directory on a new installation.

## Authenticating to RPM (Yum) Feeds

By default feeds do not require authentication and can be viewed anonymously. However, you can configure it to require authentication to access. For example, when creating feeds to host your own internal packages.

First you will need to create an API key in ProGet. You can read more about this on our [API Key](/docs/proget/reference-api/proget-apikeys) page. When creating an API Key, fill in the fields by selecting "Feeds ("Use Certain Feeds)" as the "Feed Type" and selecting the RPM feed to authenticate to. Make sure that the required permission boxes are checked, and then select "Save".

![](/resources/docs/proget-rpm-internal-apikey.png){height="" width="50%"}

Alternatively you can create a "Personal API Key", which lets users create/delete API keys that are tied to their username.

Then add the feed to your local RPM environment which will require the RPM feed URL and API key. When editing the `.repo` file, enter your API key and URL in the `baseurl` parameter:

```bash
baseurl=http://api:«api-key»@«feed-url»
```

For example when authenticating with the API key `abc12345` to the RPM feed URL `http://proget.corp.local/rpm/internal-rpm/`, your `.repo` file should look like this:

```bash
[internal-rpm]
name=internal-rpm
baseurl=http://api:abc12345@proget.corp.local/rpm/internal-rpm/
enabled=1
gpgcheck=0
```
