---
title: "パッケージのトラッキング"
order: 5
hidden: true
---

現在のソフトウェア開発では、すべてを 1 から書き上げることはまれです。多くの場合、NuGet ライブラリなど、たくさんのオープンソースのライブラリやパッケージがあり、さらに自社で開発したパッケージを、複数のアプリケーションに使いまわしするなどして、活用して開発の工数を節約しています。

しかし、裏を返せば、複数のアプリケーションに使われているパッケージのあるバージョンに脆弱性が見つかったら、そのパッケージがどのアプリケーションのどのバージョンに使われているかを調査するのに何時間もかかりかねないほど複雑化しています。

ProGet には、この問題を解決する「パッケージのトラッキング機能」があります。この機能は、Otter などのインフラ管理ツールと連携して、インフラ全体のパッケージ使用状況を可視化し、脆弱なパッケージがインストールされたサーバを迅速に特定して、そのパッケージを削除したり、適切なパッケージが適切なサーバにインストールされていることを簡単にします。

この機能は、ProGetの全てのバージョンでご利用いただけます。無料版の場合は手動で入力が必要となります。パッケージのライブスキャンに対応しているフィードは、Chocolatey、PowerShell、RPM(yum)、Debian、UPack です。ProGet はカスタマイズ可能です。拡張機能により、他の構成管理ツールとも連携できます。

## ProGet 側の設定
パッケージの使用状況の表示方法は、この機能に対応したフィードを作成するだけです。パッケージのライブスキャンは初期設定で有効になっています。設定はフィードの [Manage Feed (フィードの管理)] からご確認いただけます。

## Otter 側の設定
Otterはサーバからパッケージの使用状況を収集して表示します。Otter の設定方法は、サーバの概要ページから行います。[Packages & Containers (パッケージとコンテナ)] タブの [configure (構成)] ボタンをクリックします。どのパッケージタイプを収集するか選択します。詳しくは[Otterドキュメントのサーバパッケージ](https://www.google.com/url?q=https://docs.inedo.com/docs/otter/core-concepts/servers#packages&sa=D&ust=1602575308290000&usg=AFQjCNFLmsAGFU8zKw497HaCn4yOuXkV2w)を参照ください。

Otterのパッケージデータ収集の設定が完了後に、パッケージ/コンテナ使用状況APIへのアクセスを許可するAPIキーを作成します。
![ProGet-Tracking-package-deployment](/resources/docs/ProGet-Tracking-package-deployment.png){height="" width=""}

## ライブのパッケージ使用状況データを表示する
[Usage & Statistics (使用状況と統計)] タブに ProGet 内の収集されたパッケージのデータが表示されます。各パッケージの概要ページから、このタブをクリックすると、そのパッケージが使用されているサーバのリストと名前、ステータス、時間などの情報が表示されます。

