---
title: "Universal Feeds & Packages"
order: 3
---

The Universal Package format is very simple and can be used to package applications and components built with any technology: ASP.NET websites, NodeJS applications, Windows services, plug-ins for your applications, system configuration scripts, and so on. 

Universal Packages are designed both for general use and as a platform for creating a new proprietary package format. You can also extend the manifest file of a universal package with additional metadata (and then search based on that metadata).

## Creating Universal Packages

There are several ways to create and publish Universal Packages. These include uploading hand-crafted package files to the ProGet UI, or simply doing an HTTP Post with your own tool/scripts using the [Universal Feed API](/docs/proget/reference-api/universal-feed). To learn more about this, read [HOWTO: Create Universal Packages]()

### Using ProGet's UI

You can create and upload Universal Packages directly through the ProGet user interface. This method is useful for those that prefer the simplicity of a UI vs using CLI, and for packages with infrequent releases where automation isn't required.

Navigate to a Universal Package feed and select "Add Package" from the drop down menu. Then select "Create a Package". After entering details such as name and version, you can use the UI to either drag and drop or select files. 

![](/resources/docs/proget-upack-createpackage.png){height="" width="50%"}

From here, select "Create Package" to create and upload your newly created Universal Package to ProGet.

### Using CLI

To create and upload Universal Packages through CLI commands, you can use [`upack`](https://github.com/Inedo/upack/releases). This is a cross-platform command-line tool for creating and installing universal packages; you can also see which packages are installed on a machine.

Creating a package is performed using the `pack` command:

```bash
$ upack pack «source» [--metadata=«metadata»] [--targetDirectory=«targetDirectory»] [--group=«group»] [--name=«name»] [--version=«version»] [--title=«title»] [--description=«description»] [--icon=«icon»]
```

For more commands, read `upack`'s documentation in [the Source Code (github.com)](https://github.com/Inedo/upack)

Uploading a package to a Universal Feed is done using the `push` command:

```bash
$ upack push «package» «target» [--user=«authentication»]
```

:::(info)
Note: For more information on Authentication, read [Authenticating to Universal Package Feeds](#authentication)
:::

### Using Other Tools

There are many free and open-source tools available to help you create and publish packages in ProGet, either from your workstation, a build server, or elsewhere. See [Universal Packaging Tools](/docs/proget/feeds/universal/universal-packages#tools) to learn more.

#### Universal Package API

The [Upload Universal Packages](/docs/proget/reference-api/universal-feed/upload) endpoint in the [Universal Feed API](/docs/proget/reference-api/universal-feed) let's you upload Universal Packages to ProGet. This method will need an [API Key](/docs/proget/reference-api/proget-apikeys) with the appropriate permissions.

## Editing Packages

Universal Packages uploaded to ProGet can be edited. We strongly discourage editing Universal Packages after they have been published as they are designed to be immutable to ensure integrity and reproducibility, and doing so can lead to unexpected behavior.

However, downloading, editing, and uploading a package as a new version can be frustrating when only minor changes are needed, for example, minor edits to the metadata like tags or description. ProGet let's you make edits to a Universal Package's manifest `.json` through the UI. Navigate to a package and select "Edit Package" from the dropdown menu. This will open a window allowing you to make changes:

![](/resources/docs/proget-upack-editpackage.png){height="" width="50%"}

## Downloading Universal Packages & Package Content

There are two possible options when downloading a Universal Package:

* Download a Package in a Universal Package format, including it's metadata
* Download the only the files packaged in a Universal Package as a `zip` or `tgz` file. 

Downloading can be performed either through the UI or as a CLI command. To download only the contents of a Universal Package, add the query parameter `?contentOnly` to the URL and specify either `zip` or `tgz` as a value. For example:

```bash
$ curl https://«proget-url»/upack/«feed-name»/download/MyPackage/1.2.3?contentOnly=zip --output MyPackage-1.2.3.zip --user «user»:«password»
```

## Installing Universal Packages

You can use Inedo's [upack](https://github.com/Inedo/upack/releases) command line tool to install Universal Packages. Installing packages is done through the upack install command. For example, to install the package `MyPackage version 1.2.3` you would enter:

```bash
$ upack install MyPackage 1.2.3 --source=http://«proget-url»/upack/«feed-name» --target=«directory» --user=«user»:«password»
```

### The Universal Package Registry

The Universal Package Registry is a local system designed to track and manage packages installed using the `Inedo.UPack` library. It records metadata like package name, version, etc, ensuring traceability and compliance. It operates in machine-level, user-level, and custom contexts, with each registry consisting of a metadata file (`installedPackages.json`) and an optional package cache for auditing, repair, and staging.

For example, if a package named `hdars version 1.2.3` is installed, the registry will record metadata such as its installation date, the person that installed it, and its origin feed URL. The package cache might store `hdars.1.2.3.upack` in a structured directory, allowing the package to be reinstalled without re-downloading. This maintains consistency and lets you audit and repair installations if needed.

You can read more about the Universal Package Registry in the [Inedo.UPack](https://github.com/inedo/inedo.upack/blob/master/registry.md) repository.

## Authenticating to Universal Package Feeds { #authentication }

To upload packages, or download or install them if a feed has been configured to require authentication, you will need a username/password combination. However we strongly recommend [Creating a ProGet API Key](/docs/proget/reference-api/proget-apikeys) instead. When using an API Key, enter `api` as the username and your key as the password. For example, if installing the package MyPackage from a feed requiring authentication, you would enter:

```bash
$ upack install MyPackage 1.2.3 --source=http://«proget-url»/upack/«feed-name» --target=«directory» --user=api:«password»
```
