---
title: "Licensing Detection and Blocking"
order: 4
---

ProGet can automatically detect the license agreements that govern the third-party open source packages you use. This allows you to:
* Block or allow downloading of packages based on the license type
* See the licenses that your [Projects and Releases](/docs/proget/sca/builds) are using
* Export a [Software Bill of Materials (SBOM)](/docs/proget/sca/builds/proget-sca-sbom-importing-exporting) to share with auditors or clients

This article explains how license detection works and how to configure rules for blocking packages based on their license.

You can access ProGet's license detection and blocking features by navigating to Reporting & SCA > License Usage:

![Licensing Usage](/resources/docs/proget-licensing-summary.png){height="" width=""}

See [ProGet 6.0 and earlier](/docs/proget/sca/licenses#proget-60-and-earlier) to learn how these features worked prior to ProGet 2022.

## Why are License Agreements Important?
By using third-party open source packages in your application, you agree to the license terms stated by the authors of the packages. In many cases, these license terms are benign and permissive. In some cases, however, they are restrictive and can expose your organization to unexpected legal liabilities.

For example, if you want to use a GNU3-licensed package in your application, you must open source your application and then license it under GNU3. If your organization does not do this, it could be sued by the package authors.

To learn more, see [How to Avoid Costly Lawsuits from Unexpected NuGet License Agreements](https://blog.inedo.com/nuget/how-to-avoid-costly-lawsuits-from-unexpected-nuget-license-agreements) on our blog.

To protect against the consequences of packages with unwanted licenses, ProGet provides two workflows for managing license agreements for third-party open source packages:

## How does ProGet detect Licenses?

ProGet includes a comprehensive database of open-source licenses, curated from a number of sources such as the [SPDX License List](https://spdx.org/licenses). You can also add your own licenses to this list.

Starting in ProGet 2024, the database will also include full license texts, expert legal analysis, and detection methods to help identify package licenses. It will be periodically updated, and each time you upgrade, the bundled definitions will be automatically merged with your own licensing definitions. 

**ProGet 2023.27 and later includes a preview of this enhanced database.** To use these improved definitions, navigate to Reporting & SCA > Licenses > Manage License Types > "update definitions".


### Matching Packages to Licenses

*This applies to ProGet 2023.27 and later; see [ProGet 2023 and Earlier](#proget-2023-and-earlier) for how license detection works in earlier versions.*

In addition to a license code (such as `GPL-3.0`) and title (e.g. "GNU General Public License v3.0 only"), license definitions include five detection methods that are used to match packages to licenses.

#### SPDX IDs

[SPDX identifiers](https://spdx.org/licenses/) are used by several package types including NuGet, npm, Rubygems, and APK to indicate which license(s) a package uses. These are generally simple expressions like `GPL-3.0` that match the license code in ProGet.

However, authors can specify whatever code they'd like. This means ProGet may report an "unknown SPDX code" on some packages with non-standard licenses.

![](/resources/docs/proget-license-unknown-spdx.png){height="" width=""}

When you encounter an unknown SPDX code, you can either create a new license type or associate the code with an existing type. For complex expressions like `GPL-2.0 WITH GCC-exception`, you may wish to just add to an existing license (such as `GPL-2.0`), so they can all be covered under the same rules.

Note that *Python (PyPI, Conda)* and *R (CRAN)* packages do not use standardized SPDX codes, but instead use [Trove classifiers](https://pypi.org/classifiers/) and [proprietary specification](https://cran.rstudio.com/doc/manuals/r-devel/R-exts.html#Licensing). Internally, ProGet will convert these expressions to the matching SPDX code when possible, and display the license as an SPDX code. 

#### URLs

License URLs are primarily used in older NuGet packages to indicate the license a package uses, but are considered deprecated in favor of SPDX IDs and files. You may also see `packageid://` and `package://` URLs; these were used by ProGet 2023 and earlier instead of PUrls and Files, and are also considered deprecated.


#### Package Names
Packages with these names are always considered to have this license, regardless of what license is specified in the package. This should only be used by internal packages you create that don't specify a license.

#### Package Versions (PUrls)
Packages with these names/versions are always considered to have this license, regardless of what license is specified in the package. This should only be used when a package doesn't otherwise specify a license.

#### Embedded Files

Licenses may be embedded in NuGet, npm, PyPi, and other package types. ProGet can detect these license files in cached and local packages. These files can be managed on the license files page.

### Unknown Licenses

If a package does not specify an SPDX code or use an embedded file, then ProGet will display a warning and gives you the option to associate the package with an existing or new license type. 

![](/resources/docs/proget-license-none.png){height="" width=""}


Clicking on the "Assign License Type to Package" button will give you the option to add the Package Name or Package Version to the license.


## License Rules and Blocking
ProGet allows you to define rules to block or allow downloads based on the license of a package. These are set at the global level and can then be overridden for feeds, packages or versions by creating exceptions. 

:::(warning) (⚠ Prerequisites)
When upgrading from ProGet 2023.29 and below, you will need to enable the ProGet 2024 Vulnerabilities and Policies Preview Features. 

Read our short explanation in [HowTo: Scan and Block Packages](/docs/proget/sca/vulnerabilities/howto#prerequisites) if you need to learn how to do this.
:::

Navigate to "Administration Overview" and select "Policies (ProGet 2024 Preview Feature) under "Global Components". Then select "edit" on the right of "Global" policies.

![Edit Policies](/resources/docs/proget-policies-global-edit.png){height="" width="50%"}

From here select "edit" under License Rules.

![License Rules](/resources/docs/proget-policies-license-select.png){height="" width="50%"}

Select the "Non-compliant" tab and select the licenses you wish to block under "Non-compliant Licenses". Then select "Save".

![Add License Rules](/resources/docs/proget-license-noncompliant-select.png){height="" width="50%"}

Once a license rule is configured, packages with a blocked license will display a red warning on the Package Overview page, and ProGet will not allow the package to be downloaded.

### Default License Rules
By default, ProGet uses a "blacklist approach" to licenses: all packages can be downloaded unless there is an explicit rule blocking them. You can change this to a "whitelist" by editing the default license rule.

From the "Global Policy" page, select "edit" under "License Rules". Under "Default rule" select "Non-compliant".

![Default licensing rule](/resources/docs/proget-license-default-select.png){height="" width="50%"}

You can also configure how ProGet handles unknown licenses by selecting a rule under "Undetectable rule".

### Rule Exceptions
Exceptions to the rules set in "License Rules" can be created for feeds, packages, and versions. From the "Global Policy" page select "add exception" under "Exceptions".

![Exceptions](/resources/docs/proget-exception-select.png){height="" width="50%"}

Exceptions can now be created by specifying Scope, Package, and Version, and specifying exemption from License Rules. The "Package Name" field allows for wildcards (e.g. "Newton*"). The "Version" field allows for version ranges (E.g. ">=1.0, <2.0")

## ProGet 2023 and Earlier
ProGet 2023.29 and earlier uses less sophisticated license detection, only supporting a single SPDX Code and number of URLs. In addition, the License Definition and License Blocking Rules will be displayed on the same page, allowing you to define rules to block or allow downloads based on the license of a package. 

See [HOWTO: Filtering Packages by License](/docs/proget/sca/licenses/proget-howto-filter-package-licenses) to see more about ProGet 2023 and Earlier.

### License Rules and Blocking
Unless you've enabled the [Policies Preview Feature](/docs/proget/sca/policies) (available in ProGet 2023.30+), license rules are configured by editing the license type. You can do this by navigating to Reporting & SCA > License Usage >  "manage types".  On that page, you can click on a license to configure usage rules.

![Edit License Type](/resources/docs/proget-licensing-edit-type.png){height="" width=""}

Once a license rule is configured, packages with a blocked license will display a red warning on the Package Overview page, and ProGet will not allow the package to be downloaded.

#### Default License Rules
ProGet 2023 and earlier had a concept of "default rules" that allowed you to configure a "blacklist" or "whitelist" for desired licenses. You can configure this on Reporting & SCA > License Usage.

![Default licensing rule](/resources/docs/proget-licensing-default-rule.png){height="" width=""}

This default rule can be set at the global level and then overridden in each feed.

If ProGet is configured to block licenses, it will also block packages with unknown licenses. For example, if only one license rule is defined (e.g., allow MIT license types) and you configure ProGet to block unknown licenses, *only* packages with that license type (i.e., MIT) can be downloaded.

### ProGet 6.0 and Earlier
Prior to ProGet 2022, the user interface for configuring license detection and blocking was different.

The license blocking rules were defined as follows:
- **Global license rules:** Licenses (in the top navigation)
- **Feed specific license rules:** Feed > Manage feed > Scanning & Blocking

The default rule was configured as follows:
- **Global unknown rule:** Advanced Settings > Feeds.AllowUnknownLicenseDownloads
- **Feed-specific unknown rule:** Feed > Manage Feed > Scanning & Blocking
