---
title: "プレリリースパッケージと、再パッケージ化"
order: 2
hidden: true
---

プレリリースのバージョニングは、パッケージ管理に必須です。パッケージ名に「beta」などの文脈を追加することで、一目で、開発工程におけるパッケージの状態がわかります。

ProGet で、ファイル名に「-ci」、「-rc」をつけて、 プレリリースパッケージを再パッケージ化すれば、テストと検証がされたパッケージのみを本番環境するように明確化できます。
:::(Info) ()
rc は、release candidateの略称、
ci は、continuous integration の略称です。
:::

例、

プレリリースおよび安定パッケージバージョンの例：

* ProfitCalc 3.2.4-ci.54：CIサーバーで作成されたパッケージ（ビルド＃54）
* ProfitCalc 3.2.4-beta.2：ユーザがテストできる2番目のベータバージョン
* ProfitCalc 3.2.4-rc.1：リリース前の最終確認バージョン
* ProfitCalc 3.2.4：「安定した」またはリリース品質のパッケージ

このバージョニングは、セマンティックバージョニング（SemVer2）の一部です。

## パッケージ化の 4 つのルール
### 1. パッケージは不変。

公開されたパッケージファイルは決して変更しないでください。これは、バージョン番号がファイルに埋め込まれたメタデータの一部であるため、パッケージのバージョン番号を「編集」できないことを意味します。

### 2. テストをせずに、デプロイしない。
テストをせずに、ソフトウェアを本番環境にデプロイしないこと。

### 3. DLL地獄（依存関係地獄）にならぬよう注意する。
ソースコードを再構築すると、さまざまなソフトウェアが生成される可能性があり、ワイルドカードバージョンの依存関係を持つソフトウェアは、再構築するだけで依存関係地獄を引き起こす可能性があります。

### 4. プレリリースパッケージは、決してリリースしない。
プレリリースの場合、必然的に本番環境の準備ができていません。
:::(Info) ()
これらのルールと「依存関係地獄」については、弊社書籍の第3章「[ユニバーサルパッケージマネージャーを使用した継続的なスケーリングと継続的な配信](https://inedo.com/support/resources/ebooks/continuously-scale-deliver-upm)」で詳しく説明しています。
:::

パッケージ化の 4 つのルールと、バージョニングに準拠したプロセスを作り、それを従業員全員が100％準拠する、というのは、現実的ではありません。

ProGet の再パッケージ化機能を使えば、これらのベストプラクティスに沿ったパイプラインを簡単に作れます。再パッケージ化とは、元のパッケージとまったく同じ中身で、パッケージを作成することです。パッケージのメタデータが変更され、監査目的でパッケージ名とバージョン履歴も記録されます。

## ProGetでパッケージを再パッケージ化する方法
![ProGet-UI-Repackage](/resources/docs/ProGet-UI-Repackage.png){height="" width=""}

再パッケージ化は、すべてのユニバーサルパッケージとNuGetパッケージに組み込まれている機能です。APIを使用して、または ProGet Webインターフェイスで直接再パッケージ化できます。

ProGet Webインターフェイスを介して再パッケージ化するには：

1. 「Package Overview (パッケージの概要)」ページに移動してください。
2. ドロップダウンから「Repackage (再パッケージ)」を選択します。
3. 新しいバージョン番号を入力します。 オプションで理由を追加もできます（監査目的で）。
3.1 ドロップダウンから同じフィードを選択すると、パッケージが再パッケージ化され、同じフィードのままになります。
3.2 ドロップダウンから別のフィードを選択すると、再パッケージ化されたパッケージがターゲットフィードにプロモートされます（再パッケージ化されたバージョンはソースフィードに表示されません）。
4. [Repackage (再パッケージ化)]」をクリックします。

## 再パッケージ化履歴の表示と監査
ProGetを使用すると、ユーザはパッケージの[History (履歴)] タブで再パッケージ化の履歴を確認できます。履歴には、日付、時刻、バージョン、ユーザ名、メモなど、各再パッケージ化イベントに関する重要な値が表示されます。

これらの履歴はパッケージ自体に埋め込まれており、再パッケージ化の履歴を保持しながら、このパッケージを他のフィードに簡単に複製またはパイプライン移動できます。

ユニバーサルパッケージの場合、履歴は upack.jsonに 埋め込まれています。 NuGetパッケージの場合、履歴は .nupkg ファイルの .progetRepackagingHistory.json に（同じJSON形式で）埋め込まれます。

## その他の再パッケージ化方法

ProGet UIを使用する以外に、パッケージを再パッケージ化する方法は 2 つあります。API で呼び出すか、ユニバーサルパッケージ用 CLI を使用することです。これらの方法は、再パッケージ化プロセスの自動化に関して多くの柔軟性を提供します。

再パッケージ化時にドロップダウンから別のターゲットフィードを選択することで、1つのステップで再パッケージ化してプロモートもできます。

## CI / CDパイプラインでの再パッケージ化

例として、再パッケージ化 API を使用するパブリック BuildMaster インスタンス上にサンプルアプリケーションを構築しました。この例では、CI / CDパイプラインの一部として再パッケージ化を追加するために使用できるパターンを示しています。

アプリケーションには、デプロイプラン、パイプライン、およびソースコントールリポジトリモニター構成が含まれているため、ソースコントロールリポジトリブランチにプッシュされたコミットによってパッケージが自動的に作成され、CI リポジトリにデプロイされます。 ビルドを将来のパイプラインステージを通じてデプロイすると、ビルドが再パッケージ化されてから、NuGetパッケージを必要とするInedoプロジェクトのビルドに使用されるパブリックリポジトリに再デプロイされます。

サンプルアプリケーションは、Inedo.Coreライブラリで確認できます。

## ProGet無料版の制限
無料版では、一部の再パッケージ化機能に制限があり、API での再パッケージ化はできません。また、誰がいつ再パッケージ化したかを確認できません。 [Package Overview (パッケージの概要)] ページの [History (履歴)] タブで、再パッケージとプロモーションの履歴が、ログにdate hidden、username hidden と表示されます。