---
title: "GitHub"
order: 1
---

[GitHub](https://github.com/) is a hosting platform primarily for open-source projects, but it also has support for issue tracking, release management, and collaboration. GitHub has [three types of accounts](https://help.github.com/en/github/getting-started-with-github/types-of-github-accounts): Personal, Organization, and Enterprise, each offering a different level of security. While GitHub does have its own version of a CI/CD platform in [GitHub Actions](https://github.com/features/actions), it requires an organization's projects to be migrated to the GitHub platform in order to use it.

BuildMaster is designed to work *alongside* GitHub to provide a self-managed CI/CD solution using BuildMaster's [Git Integration](/docs/buildmaster/builds-continuous-integration/buildmaster-git-source-control) and [Issue Tracking](/docs/buildmaster/tools-service-integrations/buildmaster-integrations-github/buildmaster-integrations-github-issues).

## Connecting to GitHub
BuildMaster's [Git Integration](/docs/buildmaster/builds-continuous-integration/buildmaster-git-source-control) allows you to connect to GitHub at application creation or through the application's settings page.  To connect BuildMaster to GitHub:

1. Either create a new application or add a new connection on the application settings page, then select Git Repository
![select-connection-type](/resources/docs/select-connection-type.png){width="50%"}
2. Select the GitHub connection type
![git-connect-to-service](/resources/docs/git-connect-to-service.png){width="50%"}
3. Enter your GitHub user name and [personal access token(#Generating-a-GitHub-Personal-Access-Token)] and click Select GitHub Repository
![connect-to-github](/resources/docs/connect-to-github.png){width="50%"}
4. Select your GitHub namespace and enter or select your repository and click Save Repository
![connnect-github-repository](/resources/docs/connnect-github-repository.png){width="50%"}

The GitHub repository will then be [synchronized to your server](/docs/buildmaster/builds-continuous-integration/buildmaster-git-source-control#synchronized-git-repositories) and you will see a successful synced message.
![successfully-synced-github](/resources/docs/successfully-synced-github.png){width="50%"}

### Editing a GitHub Connection 

You can edit these items directly to enable advanced scenarios (such as a shared repository) by clicking view all on the Settings page, or by going to Admin > Credentials & Resources.  See [Credentials & Resources](/docs/buildmaster/configuring-for-your-team/buildmaster-administration-resource-credentials) to learn more.

## Generating a GitHub Personal Access Token

When connecting BuildMaster to GitHub, you need to use a [GitHub Personal Access Token (PAT)](https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token). To generate this token:
1. Navigate to your GitHub project
2. In the upper right corner, click your user icon, and then click _Settings_
3. Navigate to _Developer Settings > Personal Access Tokens > Tokens_
4. Click Generate new token, then click Generate new token (classic)
5. Enter a note, expiration, and select the repo scope (Full control of private repositories)
6. Click Generate Token

:::(Info) (NOTE:)
GitHub has recently added fine-grained tokens. Although these tokens should work with BuildMaster, they are still in beta and we do not recommend using them.
:::

## Browsing GitHub Repositories

After adding a synchronized GitHub repository to an application, you'll be able to browse that repository's branches, source code, and commits—as well as the changes between builds/releases—directly from BuildMaster's web UI.  See our [synchronized Git repositories documentation](/docs/buildmaster/builds-continuous-integration/buildmaster-git-source-control#synchronized-git-repositories) to learn more.

::: (Info) (Note:)
When viewing branch, tag, or commit details, you can also click the "browse on GitHub" link to view details in GitHub directly.
:::

## Issue Tracking
When you connect your BuildMaster application to a GitHub issue tracker, your issues are automatically synchronized with BuildMaster's issues. This allows you to browse issues, associate them with specific releases, and block releases if there are untested or unresolved issues in BuildMaster. See our [GitHub Issue Tracking](/docs/buildmaster/tools-service-integrations/buildmaster-integrations-github/buildmaster-integrations-github-issues) documentation for more information.

BuildMaster also allows you to create or update your Issues with OtterScript operations.

::: (Internal) (TODO)
Document GitHub Issue Source.
:::


## GitHub and Scripting
When your application uses a synchronized GitHub repository, you'll be able to create a build from any commit in the repository. When creating a build in this manner, the selected commit - along with its branch and repository - will be associated with that build and displayed throughout the UI. You can access those values in scripts with the `$Commit`, `$Branch`, and `$Repository` variable functions.  See [Git Build Scripts & Automations](/docs/buildmaster/builds-continuous-integration/buildmaster-git-source-control#build-scripts-operations) for more information.

### GitHub Git Operations

The GitHub integration supports all the standard [BuildMaster Git operations](/docs/buildmaster/builds-continuous-integration/buildmaster-git-source-control#build-scripts-operations), but there are a couple things to keep in mind when using these operations.  


#### Using Other Git Repositories
By default, `Git::Checkout-Code` will use your Git Connection to connect to your repository.  If you would like to select a repository that is different than what your Git connection specifies; navigate to your repository in GitHub, click the "<> Code" button and copy the URL under Clone with HTTPS, then set the `RepositoryUrl` parameter to it in the`Git::Checkout-Code` operation.

In cases like this, you can specify input parameters like this.
```
Git::Checkout-Code
(
    RepositoryUrl: https://github.com/inedo/ProfitCalcNet,
    BranchOrCommit: master,
    To: c:\build\space\src,
    CommitHash => $CommitId
);
Log-Information Checked out at $CommitId from my-repo;
```

#### Git::Set-CommitStatus Operation
GitHub allows you to set the "status" of a particular commit, as it relates to a successful build. This status is often displayed in GitHub's UI when listing commits.

To set this status in BuildMaster, you can simply call the operation with the desired status. In general, you'll want to use a `try..catch` statement as follows:
```
Git::Checkout-Code;

Git::Set-CommitStatus pending;
try
{
    ... perform build operations...
    Git::Set-CommitStatus success;
}
catch
{
    Git::Set-CommitStatus failure;
    throw;
}
```

Like the `Git::Checkout-Code` operation, the operation will use `$Commit` and  `$Repository` if you don't specify them as parameters. The operation can also automatically determine the status, but you can override that by specifying the  `Status` parameter:
* `pending` - a build is about to start or is running
* `success` - build completed successfully
* `failure` - execution didn't complete or there was an error unrelated to build compilation/tests
 
 #### Git::Create-PullRequest and Git::Merge-PullRequest

Just like `Git::Checkout-Code`, the `Git::Create-PullRequest` operation will use your Git Repository connection to create a pull request in GitHub.  Here is an example of using a repository that is different than what your Git Repository connection specifies:

```
Git::Create-PullRequest
(
    Title: My New Thing,
    Target: main,
    Repository: https://github.com/inedo/ProfitCalcNet
);
```

This operation will also record the ID of the Pull Request on the Build, so that you can later access it with `$PullRequestId`.

:::(Info) 
The [Feature Branch Workflow Pipeline](/docs/buildmaster/builds-continuous-integration/buildmaster-ci-git-workflows/buildmaster-git-feature-branches) will create a script with the `Git::Create-PullRequest` operation. Try it out to see this in action.
:::

You may want to extend your Feature Branch workflow and let BuildMaster do the merging.

To complete a merge request, you can run the operation without parameters:
```
Git::Merge-PullRequest;
```

This will use the `$PullRequestId` if you don't specify it as a parameter.

### GitHub Issue Operations
Although BuildMaster has an issue source to synchronize issues between BuildMaster and GitHub, there are times where you need to work with these issues and milestones in your build and release scripts.  The following operations are supported in BuildMaster and will use the credentials, API URL, organization, and repository specified in your GitHub resource.  You can also override these values with the following parameters:
- UserName
- Password
- OrganizationName
- RepositoryName
- ApiUrl



#### GitHub::Create-Issue
This operation allows you to create a new issue in GitHub.

To add a new work item in the Kramerica project under the 1.1.0 milestone, you can use this operation:
```
GitHub::Create-Issue
(
    From: GitHubCredentials,
    Title: QA Testing Required for $ApplicationName,
    Body: This issue was created by BuildMaster on $Date,
    Milestone: 1.1.0,
    Number => $IssueNumber
);
```

This example will allow you to update/close the issue in other operations by using the `$IssueNumber` variable.

You can also specify a list of labels (ex: `Labels: @(Label1, label2)`) and a list of assignees (ex: `Assignees: @(sdennis)`) when creating the issue.

#### GitHub::Create-IssueComment
This operation allows you to add a comment to a GitHub issue.

To add a comment to an issue, you can use this operation:
```
GitHub::Create-IssueComment
(
    Credentials: GitHubCredentials,
    Number: $IssueNumber,
    Body: Issue was fixed in version $ReleaseNumber
);
```
#### GitHub::Close-Issue
This operation allows you to close a GitHub issue.

To close an issue, you can use this operation:
```
GitHub::Close-Issue
(
    Credentials: GitHubCredentials,
    Number: $IssueNumber
);
```

#### GitHub::Ensure-Milestone
This operation ensures a milestone exists at the specified status.

To create a milestone, you can use this operation:
```
GitHub::Ensure-Milestone
(
    Credentials: GitHubCredentials,
    Title: $ReleaseNumber,
    DueDate: $Date,
    Description: Automated release for $ReleaseNumber,
    State: open
);
```

To close a milestone theat already exists, you can use this operation:
```
GitHub::Ensure-Milestone
(
    Credentials: GitHubCredentials,
    Title: $ReleaseNumber,
    State: closed
);
```

#### GitHub::Ensure-Release
This operation ensures a release exists.

To create a release in draft mode, you can use this operation:
```
GitHub::Ensure-Release
(
    Credentials: GitHubCredentials,
    Title: Release $ReleaseNumber,
    Tag: $ReleaseNumber,
    DueDate: $Date,
    Description: Automated release for $ReleaseNumber,
    Draft: true,
    Prerelease: false
);
```
Creating a release in draft mode is helpful when attaching assets to a release.  You can also specify a `Target`, which is a commit or a branch, to link the release to.  If you leave this blank, it will default to latest commit of default branch (normally main or master).


To complete a release that is in draft mode, you can use this operation:
```
GitHub::Ensure-Release
(
    Credentials: GitHubCredentials,
    Tag: $ReleaseNumber,
    Draft: false
);
```

#### GitHub::Upload-ReleaseAssets
This operation uploads and attaches files to a GitHub release.

To upload assets to a release, you can use this operation:
```
GitHub::Upload-ReleaseAssets
(
    Credentials: GitHubCredentials,
    Tag: $ReleaseNumber,
    SourceDirectory: /publish
);
```


You use the `Include` and `Exclude` parameters to further control the files that will be uploaded.  These parameters follow our [wildcard masking rules](https://inedo.com/support/kb/1119/wildcard-masking-in-buildmaster-and-otter), which provide a lot of flexibility in the files you want to capture. 

For example, you could capture only `.dll` files:

```
GitHub::Upload-ReleaseAssets
(
    Credentials: GitHubCredentials,
    Tag: $ReleaseNumber,
    SourceDirectory: /publish,
    Include: @(**.dll)
);
```

The `Exclude` parameter can be useful for removing test configuration files. For example:

```
GitHub::Upload-ReleaseAssets
(
    Credentials: GitHubCredentials,
    Tag: $ReleaseNumber,
    SourceDirectory: /publish,
    Exclude: web.appSettings.config
);
```

## Installing the GitHub Extension 

The GitHub extension is installed by default when you install BuildMaster. You can upgrade the extension by navigating to the *Admin > Extensions* page in your instance of BuildMaster and clicking the update link to the right of the GitHub extension. Once the GitHub extension has been upgraded, it can be reverted back to the built-in version by navigating to *Admin > Extensions > GitHub* and then selecting the Change Version button in the upper right corner.

If your instance doesn't have Internet access, you can upgrade/downgrade it by [manually installing the GitHub extension](/docs/buildmaster/reference/extensions#manual-install) after downloading the [GitHub Extension Package](https://proget.inedo.com/feeds/Extensions/inedox/GitHub).

:::(Info) (NOTE:)
Built-in extensions cannot be deleted or downgraded past the included version.
:::