---
title: "NuGet (.NET) Packages and Feeds in Proget"
nav-title: "NuGet (.NET)"
order: 3
---

NuGet is a package format developed by Microsoft to distribute free and open source. NET libraries. Usually, these packages are publicly available on NuGet.org and are used by Visual Studio or the nuget.exe command-line client.

- [NuGet command-line Reference](https://docs.microsoft.com/en-us/nuget/tools/nuget-exe-cli-reference)


With ProGet, you can use NuGet packages to distribute private proprietary libraries within your organization. To do this, simply create a NuGet feed: "Feeds" > "Create New Feed" > Type = NuGet.

Then configure Visual Studio to use your feed as a new package source.

You can also use ProGet as a proxy for NuGet.org, both to block [improper licenses](/docs/proget/sca/licenses) and [security vulnerabilities](/docs/proget/sca/vulnerabilities), and to cache packages in case the Internet or NuGet.org goes down. To do this, create a connector ("Feeds" > "Connectors" > "Create New Connector" > "NuGet") and then associate it with a feed ("Manage Feed" > "Connectors").

### Installing Packages

NuGet packages are installed using [NuGet CLI](https://docs.microsoft.com/en-us/nuget/quickstart/install-and-use-a-package-using-the-dotnet-cli). To install a package from a ProGet feed, use the following command:

```bash
nuget install «package-name» -Version «package-version» -Source http://«proget-server»/nuget/«feed-name»/
```

## Creating and Publishing NuGet Packages 

The [NuGet package format](https://docs.microsoft.com/en-us/nuget/schema/nuspec) is well-documented, and you can create packages in a number of ways, including [directly from Visual Studio](https://docs.microsoft.com/en-us/nuget/guides/create-net-standard-packages-vs2017) or using [nuget.exe](https://docs.microsoft.com/en-us/nuget/create-packages/creating-a-package). 

:::(Info) (CI/CD for NuGet Packages!)
Check out the [NuGet Packages documentation in BuildMaster](/docs/buildmaster/development-platforms/buildmaster-platforms-dotnet/buildmaster-platforms-dot-net-nuget) to learn how to apply the principles of Continuous Integration & Continuous Delivery (CI/CD) to quickly test and deploy packages you create along with your application
:::

Once you've created a package, there are four ways you can publish it to ProGet:

- Upload from disk - upload a pre-packaged NuGet package (.nupkg) from disk
- Push via NuGet Command Line Utility - uses the nuget.exe command line to add a package to the local feed
- Pull from another Feed - pulls a package from another NuGet feed (such as nuget.org). Note: The feed URL must be a NuGet v2 URL at this time, e.g. `https://nuget.org/api/v2`
- Bulk Package Import/File Copy - import multiple existing packages at once

For more specific instructions on how to add a package to a feed, click the `Add Package` button on your NuGet feed.

## NuGet API Key 

NuGet client tools (such as nuget.exe and NuGet Package Explorer) have the option to use a "NuGet API Key" as an authentication mechanism for publishing packages. This makes a lot of sense for the NuGet Gallery, since it is a community-run site where anyone can publish packages that they own. However, in enterprise environments, the concept of "individual package ownership" cannot be fully implemented.

In ProGet, a principal (user or group) either has privileges to publish a package to a feed or not. This allows ProGet administrators to more easily control access and usage through LDAP and groups, rather than through community mechanisms like API Keys. However, if you want to use a NuGet API key when pushing to ProGet, you have two options:

- **username:password as an API Key** - ProGet will allow users to authenticate in this mode using an API Key in the format: `username:password`. For example, you can push a package to a Feed with the default Admin account in ProGet using the `-ApiKey Admin:Admin` option with nuget.exe
-   **[Create ProGet API Key](/docs/proget/reference-api/proget-apikeys)** - you can create an API Key in ProGet (Admin &; API Key &; Access Logs) with Feed Access; you can further restrict this key by associating it to a user you've already given specific permissions

## Symbols and Source Packages 

A NuGet feed in ProGet may be configured as a Symbol/Source server compatible with debuggers such as Visual Studio and WinDbg. See [Symbols and Source Code in ProGet](/docs/proget/feeds/nuget/symbol-and-source-server) for more information.

## Using the NuGet API

ProGet implements the  [NuGet Server API](https://learn.microsoft.com/en-us/nuget/api/overview), which is extensively documented by Microsoft.

:::(Info) (⚙ NuGet API Endpoint URL)
 `«proget-base»/nuget/«feed-name»/v3/index.json`
:::

This is referred to as the JSON-LD (v3) API. ProGet also implements the older NuGet API, called the ODATA (v2) API.

### NuGet ODATA (v2) API

NuGet feeds can also be queried with an older API, called the ODATA (v2) API.

This API is not very well documented, and requires understanding the [ODATA protocol](http://www.odata.org/getting-started/basic-tutorial/) and NuGet's special ODATA extensions. The blog article [Fun With NuGet Web Api](http://chris.eldredge.io/blog/2013/02/25/fun-with-nuget-rest-api/) shows some examples of how to use this API.

In addition, here are a few common queries you may find helpful:

**Listing all packages of a feed in JSON format**

```bash
https://«proget-server»/nuget/«feed-name»/Packages?$format=json
```

**Manually downloading packages from a ProGet feed**

```bash
https://«proget-server»/«feed-name»/«packageName»/«versionNumber[optional]»
```

**ODATA package queries**

```bash
https://«proget-server»/nuget/{feed-name}/Packages?$filter=Id%20eq%20'«package-name»'
```

**Get Latest Version number of a package**

```bash
https://«proget-server»/nuget/{feed-name}/Packages()?$filter=Id%20eq%20%27«package-name»%27%20and%20IsAbsoluteLatestVersion&$top=1
```

### NuGet.org and the ODATA (V2) API

:::(Warning)
NuGet.org deprecated certain V2 ODATA queries, which will lead to an error if you have a connector to NuGet.org and query the feed with these queries. See  [Problems With My NuGet.org Connectors
](/docs/proget/feeds/nuget/problems-with-my-nuget-org-connectors) to learn more.
:::

Because the  ODATA (v2) API has limited support on NuGet.org, ProGet will always use the JSON-LD (v3) endpoint ( `https://api.nuget.org/v3/index.json`) if the connector host name is nuget.org. You can add an override token (`#v2`) at the end of a nuget.org URL, such as `http://nuget.org/api/v2#v2`, to force the ODATA (v2) protocol.

## Vulnerability Integration With Visual Studio and The NuGet CLI

Begining in ProGet 2023.5, we have added support to show [vulnerability information](https://devblogs.microsoft.com/nuget/how-to-scan-nuget-packages-for-security-vulnerabilities/) directly in Visual Studio and the NuGet CLI.  You will see the severity of your vulnerability along with a link to see the vulnerability details in ProGet.

When selecting a packge version with a vulnerability in Visual Studio, you will see the severity with a clickable link to the vulnerability in ProGet.
![proget-nuget-vulnerability-visual-studio](/resources/docs/proget-nuget-vulnerability-visual-studio.png){height="" width=""}

When running `dotnet list package --vulnerable` in the NuGet CLI, you will see a list of vulnerable packages with their severity and a link to the vulnerability in ProGet.
![proget-nuget-vulnerability-nuget-cli](/resources/docs/proget-nuget-vulnerability-nuget-cli.png){height="" width=""}

:::(INFO) (Note:)
ProGet Free edition limits vulnerability information shown in Visual Studio and the NuGet CLI.
:::

## Deprecation Integration With Visual Studio and The NuGet CLI

ProGet will show deprecation information directly in Visual Studio and the NuGet CLI.  You will see if a specific version of the package was deprecated along with the specified reason. This works for both packages that come from a NuGet connector and packages that were deprecated using the ProGet UI.

When selecting a package version that has been deprecated in Visual Studio, you will see a warning that the package has been deprecated. If the package has been installed in your project, you will also see a shield in the package list.

![nuget-deprecated-visualstudio](/resources/docs/nuget-deprecated-visualstudio.png){height="" width=""}

When running `dotnet list package --deprecated` in the NuGet CLI, you will see a list of deprecated packages installed in your project along with the deprecation reason.

![nuget-deprecated-cli](/resources/docs/nuget-deprecated-cli.png){height="" width=""}

### Troubleshooting

Visual Studio and the NuGet CLI heavily caches this information and may take time to show this information after a package has been marked as deprecated. Due to this caching, parts of Visual Studio (version drop-down, version details, and package list) may show the deprecation information at different times. 

To force the NuGet CLI to update its deprecated packages, you will need to first clear the NuGet HTTP Cache using the command `dotnet nuget locals http-cache --clear`. Then the next time you run `dotnet list package --deprecated,` the deprecation information will show immediately.

To force Visual Studio to update its deprecated packages, you will need to navigate to "Tools" > "Options" > "NuGet Package Manager" > "General" and then click "Clear All NuGet Storage". This will clear the entire NuGet cache (including cached packages) from the machine and then the deprecated information will show immediately.

## Legacy (Quirks) NuGet Feeds 

NuGet feeds created before ProGet 5.0 are considered legacy NuGet (Quirks) feeds. The Quirks feed type uses the loose semantic versioning rules that NuGet.org has historically favored. In ProGet 5.0, new NuGet feeds now use a more sophisticated versioning scheme that takes into account the Semantic Versioning 2.0 rules for pre-release version strings. However, versions that violate the SemVer2 specification will still be displayed in SemVer2 feeds.

To migrate a legacy NuGet (Quirks) feed, click the Migrate link on the Manage Feed page. ProGet opens a confirmation dialog with a set of migration options. When performing a migration, ProGet performs the following steps:

- Set the feed to `disabled` state
- Add new metadata (Database) entries to the feed
- Remove old (Quirks) metadata for the feed
- Reactivate the feed

This migration is strictly a database operation that does not require your packages to be changed at all. By default, the migration is performed as a single database transaction, so it can be undone in the unlikely event of an error. If you have a very large number of packages in your feed (> 10,000), we strongly recommend that you back up the ProGet SQL database before performing the migration and disable this single transaction mode by clearing the corresponding check box in the Migrate Feed dialog.

Legacy (Quirks) NuGet Feeds were removed in ProGet 5.3, and upgrading will be blocked unless you've migrated or deleted all of these feeds.

### Legacy NuGet API Key 

NuGet (Quirks) feeds supported an API key definition directly on the Manage Feed page; these keys will be removed when upgrading to ProGet 5.3.

Legacy NuGet API keys behave slightly differently than ProGet API keys: if a legacy key is defined for the feed, it is checked *in addition* to the authenticated user. If the same key is defined as both a legacy key and a ProGet key, the ProGet key takes precedence.

## Repackaging 

[Repackaging](/docs/proget/packages/repackaging) is a process of changing a package's version without changing its contents, enabling use cases such as converting a pre-release package to a stable version, and more.

ProGet supports NuGet repackaging natively. To view an example of how it can be accomplished using the [Repackaging API](/docs/proget/packages/repackaging) in a CI/CD system, you can view an [example application](https://buildmaster.inedo.com/applications/2/overview) in our public BuildMaster instance.

## CI Packages and NuGet Caching
The NuGet client maintains a 30-minute HTTP cache for package restore responses. In situations where you deploy more than one new version of a package within 30 minutes, and produce a CI build referencing each of those packages within that 30-minute window, your build will likely fail with a package not found error. This is a known issue in NuGet, and can be worked around by deleting the http cache on your build server prior to restoring packages:

```bash
nuget locals http-cache --clear
```

See [NuGet GitHub Issue 3116](https://github.com/NuGet/Home/issues/3116) for more information about this error.

## Deleting and Unlisting Packages 

You can delete (permanently remove) or unlist (hide from most search results) NuGet packages from your feed by navigating to the package page and clicking the appropriate Delete Package or Unlist Package from List button. These actions require the `Feeds_DeletePackage` or `Feeds_UnlistPackage`  permission attribute, respectively.

To programmatically delete a package from your feed, you can use the NuGet CLI's [delete command](https://docs.microsoft.com/en-us/nuget/reference/cli-reference/cli-ref-delete), or make a `DELETE` request via HTTP:

```bash
DELETE http://{proget-server}/nuget/{feed-name}/package/{ID}/{VERSION}`
```

Note that this behavior is different than [NuGet.org's DELETE command](https://docs.microsoft.com/en-us/nuget/api/package-publish-resource#delete-a-package), which unlists packages instead.

To programmatically unlist (or relist) a package, you can use the `NuGetPackagesV2_SetListed` method within the [Native API](/docs/proget/reference-api/proget-api-http).
