---
title: "Conda (Python)"
order: 14
---

A Conda feed in ProGet acts as a private Conda package repository. Packages can be used directly by the Conda client and can also be browsed directly on the ProGet website.

:::(Info)
Conda feeds are available starting in ProGet 6.0.7.
:::

## Prerequisite Configuration

Although ProGet was tested with older versions, we recommend using Conda 4.10.0 or higher. You can use `conda --version` to see which version you have installed.

### Conda Client Configuration

Before installing packages from ProGet, you should add ProGet to your list of Conda channels by using the [`conda config` command](https://docs.conda.io/projects/conda/en/latest/user-guide/tasks/manage-channels.html).

```shell
conda config --add channels http://«proget-server»/conda/«feed-name»
```

If you want to install packages only from ProGet, then you'll want to remove other channels. 

```shell
$ conda config --show channels
channels:
 - defaults
 http://«proget-server»/conda/«feed-name»

$ conda config --remove channels defaults
```

Note that these sources are stored in your `~/.condarc` file.

#### Authenticated Feeds & Channels

By default your Conda feeds will not require authentication and can be viewed anonymously. However you can configure them to require authentication. This is recommended when hosting your own internal packages in a feed, in addition to proxied packages from an OSS repository. 

Feeds can be authenticated with a username and password string `«username»:«password»` but we strongly recommend using an API key for this, with `api` as the username, and then API Key as the password. You can read more about creating one on our [API Key](/docs/proget/reference-api/proget-apikeys) page. 

When creating an API Key, fill in the fields by selecting "Feeds ("Use Certain Feeds)" as the "Feed Type" and selecting the Conda feed to authenticate to. Make sure that the required permission boxes are checked, and then select "Save".

![API Key](/resources/docs/proget-conda-apikey-3.png){height="" width="50%"}

To add and authenticate the feed to a local Conda environment, enter the following, containing both URL and API Key:

```bash
$ conda config --add channels http://api:«api-key»@«feed-url»
```

For example, when authenticating with the API key abc12345 to the URL `http://proget.corp.local/conda/public-conda/` you would enter:

```bash
$ conda config --add channels http://api:abc12345@proget.corp.local/conda/public-conda/
```

Alternatively, you can edit your `~/.condarc` file to include basic authentication credentials in the channel URL.

These credentials can be your ProGet username and password, or a ProGet API key (that uses "api" as the username). For example:
* `http://«username»:«password»@«proget-server»/conda/«feed-name»`
* `http://api:«api-key»@«proget-server»/conda/«feed-name»`

You can also override the channel in the `conda install` and `conda search` command and include authentication in the URL.  This can be done using the `--override-channels` parameter and formating the URL to include the username and password `--channel http://«username»:«password»@«proget-server»/conda/«feed-name»`. For example:

```shell
$ conda install «package-name»=«package-version» --channel http://«username»:«password»@«proget-server»/conda/«feed-name» --override-channels
```

### Testing Client Configuration

You can use the [`conda config` command](https://docs.conda.io/projects/conda/en/latest/commands/config.html) to make sure that your client is properly connected to ProGet.

```bash
$ conda config --show channels
```

You can also search for packages using the [`conda search` command](https://docs.conda.io/projects/conda/en/latest/commands/search.html):

```shell
$ conda search «search-string»
```

## Installing Packages

You can use Conda packages from ProGet just like you would from anaconda.org. Packages are generally installed using the [`conda install` command](https://docs.conda.io/projects/conda/en/latest/commands/install.html):


```shell
$ conda install «package-name»=«package-version»
```

## Creating and Publishing Packages

There are no special considerations when creating Conda packages for use in ProGet. ProGet supports all types of Conda packages, including `.tar.bz2` files and the newer `.conda` format files. You can read more about creating and publishing packages in our [HOWTO: Publish Conda Packages to a Private Repository in ProGet](/docs/proget/feeds/conda/howto-conda-publish) guide.

## Using pgscan With Conda and ProGet SCA

`pgscan` is a [free and open-source](https://github.com/inedo/pgscan) tool designed to run immediately after building your application, generally as part of the Continuous Integration (CI) process. Starting in 1.5.6, pgscan added support to scan a [Conda environment file](https://conda.io/projects/conda/en/latest/user-guide/tasks/manage-environments.html#building-identical-conda-environments).

To create a Conda environment file, you will need to run either:

```bash
conda list --explicit > requirments.txt
```

or

```bash
conda list --export > requirments.txt
```

This will list create a text file with a list of dependencies used by your Conda library or application.  Once this file has been generated, you will need to run the `pgscan identify` passing your requirements.txt to the `--input` command.  

For example, to run pgscan for your Conda application, you would run:

```bash
conda list --explicit > requirments.txt
pgscan identify
 --api-key=mySecretKey1000
 --proget-url=https://proget.corp.local/
 --input=requirements.txt
 --type=Conda
 --project-name="My Application"
 --version=5.00.21
```