---
title: "npm (Node.js)"
order: 9
---

npm (Node Package Manager) is the a widely used package manager for JavaScript, enabling developers to manage and share libraries, frameworks, and utilities. 

Using ProGet's ["Feeds"](/docs/proget/feeds/feed-overview) as npm repositories will let you to consolidate your package management and maintain control over which packages are used in your organization. In addition to [publishing and hosting your private npm packages](/docs/proget/feeds/npm/howto-npm-publish), ProGet can serve as a [proxy for public npm repositories](/docs/proget/feeds/npm/howto-npm-proxy), helping you cache and control dependencies that are pulled from [npmjs.com](npmjs.com).
 
This page covers setting up [npm](https://www.npmjs.com/) and [Yarn](https://yarnpkg.com/) clients with ProGet. Additionally, you can also use [pnpm](https://pnpm.io/) with ProGet. The commands are similar, but we recommend reading the [official documentation](https://pnpm.io/motivation) for details.

## Adding an npm Feed as a Source

To publish and install packages from your npm feed in ProGet, you'll need to add it as a source in your npm client. To do this you will need to use the `npm config set registry` command: 

```bash
$ npm config set registry http://«proget-url»/npm/«feed-name»
```

Or in Yarn, by using the `yarn config set registry` command:

```bash
$ yarn config set registry http://«proget-url»/npm/«feed-name»
```

You can confirm that the feed has been set correctly by using `npm get registry` for npm, `yarn config get registry` for Yarn. 

For more information, as well as how to proxy npm packages, you can read our [HOWTO: Proxy Packages from the npm Registry in ProGet](/docs/proget/feeds/npm/howto-npm-proxy) guide.

## Authenticating to npm Feeds { #authenticate-feed }

By default, npm feeds in ProGet do not require authentication and can be viewed anonymously. However, you can set a feed to require authentication to access. 

Feeds can be authenticated with a username and password string `«username»:«password»` but we strongly recommend using an API key for this, with `api` as the username, and then API Key as the password. You can read more about creating one on our [API Key](/docs/proget/reference-api/proget-apikeys) page. 

When creating an API Key, fill in the fields by selecting "Feeds ("Use Certain Feeds)" as the "Feed Type" and selecting the Conda feed to authenticate to. Make sure that the required permission boxes are checked, and then select "Save".

![](/resources/docs/proget-npm-apikey.png){height="" width="50%"}

To authenticate you'll need to add an `_auth` token. This is the string `api:«api-key»` (or `«username»:«password»`) that's been base64-encoded. 

:::(info) (Base64 Encoding is Required)
npm only supports base64-encoded tokens, which you'll need to create. You can search on Google to find a website that can do it for you, use the `btoa()` function in your browser's development console, or a Powershell Script. To encode your username/password or API key in base64 you can use this PowerShell script:

```powershell
[Convert]::ToBase64String([System.Text.Encoding]::UTF8.GetBytes("api:«api-key»")) 
```
Or press F12 to open the Developer Tools, click on the "Console", then run the following script:

```JavaScript
btoa('api:«api-key»')
```
:::

If you haven't already, configure your npm client with your npm feed using the `npm config set registry` command: 

```bash
$ npm config set registry http://«proget-url»/npm/«feed-name»
```

### For npm version 9.4+ or Yarn 1.22+

npm 9.4+ and Yarn 1.22+ requires that `_auth` tokens are scoped to a server and url. The following `npm config set` command will add the appropriate value to your `.npmrc` file. 

```bash
$ npm config set //«proget-server»/npm/«npm-feed-name»/:_auth «encoded-auth-token»
$ npm config set //«proget-server»/npm/«npm-feed-name»/:email «your-email-address»
```

Or by using `yarn config set` in Yarn:

```bash
$ yarn config set //«proget-server»/npm/«npm-feed-name»/:_auth «encoded-auth-token»
$ yarn config set //«proget-server»/npm/«npm-feed-name»/:email «your-email-address»
```

Make sure to also replace `«proget-server»` with the name and port of your ProGet server and `«npm-feed-name»` with the name of your npm feed. It is also recommended that you set the email associated with this registry.

::: (Warning) (npm login support)
When using the `npm login` and the `npm adduser` commands in npm 9 and above, ProGet 2023.17 or greater is required.
:::

### For npm versions 8 and below

The following `npm config set` commands will add the appropriate value to your `.npmrc` file. As versions below Yarn 1.22 do not support setting authentication tokens via the CLI, they will need to be [set in the .npmrc file](#auth-npmrc)

```bash
$ npm config set always-auth true
$ npm config set _auth «encoded-auth-token»
$ npm config set email «your-email-address»
```

### Using scoped registries

To use a registry for scoped packages, you'll need to specify the scope and namespace.

Before setting the auth token, you'll need to set a configuration scope with `npm config set`:

```bash
$ npm config set @«scope-name»:registry «feed-api-endpoint»
```

Or in Yarn with `yarn config set`:

```bash
$ yarn config set @«scope-name»:registry «feed-api-endpoint»
```

Then, you'll need to set a namespace-qualified auth token [with the commands above](#for-npm-version-9.4-and-above).

For example, if you wanted to scope the `@kramerica` packages to the `private-npm` feed on the `packages.kramerica.corp` server, you'd run these commands:

```bash
$ npm config set @kramerica:registry https://packages.kramerica.corp/npm/private-npm
$ npm config set //packages.kramerica.corp/npm/private-npm:_auth YXBpOmFwaWtleTEyMzQ1
$ npm config set //packages.kramerica.corp/npm/private-npm:email support@kramerica.corp
```

The same example can be applied to Yarn with `yarn config set` instead.

### (Advanced) Authenticating using an .npmrc or .yarnrc file { #auth-npmrc }

The `npm config` and `yarn config` commands are the more reliable and safe ways to make configuration changes because they contain proper safeguards and validation checks to ensure proper structure in the `.npmrc` or `.yarnrc` files. There are times when you may need to edit these files directly or create a custom file to use with the `--userconfig` parameter.

The `.npmrc` or `.yarnrc` files can be stored:
- per-project (`/path/to/my/project/.npmrc`)
- per-user (`$HOME/.npmrc` or via the environment variable `$NPM_CONFIG_USERCONFIG`)
- global (`$PREFIX/etc/npmrc` or via the environment variable `$NPM_CONFIG_GLOBALCONFIG`)
- npm's installation directory (`/path/to/npm/npmrc`)
- User specified with the `--userconfig` parameter

#### Examples for npm 9.4+ or Yarn 1.22+

##### npm

```bash
registry=http://proget/npm/private-npm
always-auth=true
//proget/npm/private-npm:_auth=YXBpOmFwaWtleTEyMzQ1
```

##### Yarn

```bash
registry "http://proget/npm/private-npm"
always-auth true
_auth="YXBpOmFwaWtleTEyMzQ1"
```

#### Examples for below npm 9.4 or Yarn 1.22

##### npm

```bash
registry=http://proget/npm/private-npm
always-auth=true
//proget/npm/private-npm:username=api
//proget/npm/private-npm:_password=YXBpa2V5MTIzNDU=
```

##### Yarn

```bash
registry "http://proget/npm/private-npm"
always-auth true
//proget/npm/private-npm:username=api
//proget/npm/private-npm:_password=YXBpa2V5MTIzNDU=
```

The passwords in all examples are a Base 64 encoded version of just your password. For scoped registries, you can also add `@kramerica:registry=http://proget/npm/private-npm` right after your registry.

## Installing npm Packages

After creating an npm feed and setting it up in your npm client, you can install packages using the `npm install` command:

```bash
$ npm install «package-name»@«package-version»
```

Or in Yarn using the `yarn add` command:

```bash
$ yarn add «package-name»@«package-version»
```

### Vulnerabilities & npm Audit

Starting in ProGet 2023.22, `npm audit` support has been added to pull vulnerability data directly from ProGet. You can also use `yarn audit` in Yarn for similar functionality. This is enabled by default on all npm feeds that have the [vulnerability display and blocking feed feature](/docs/proget/overview#step-4-select-feed-features) enabled. Support can be enabled, disabled, or configured to proxy to a remote source by navigating to the npm feed's "Manage Feed" page and configuring `npm audit` setting.

Using `npm audit` together with ProGet's [Vulnerability Scanning and Blocking](/docs/proget/sca/vulnerabilities) allows you to assess detected vulnerabilities and how they affect your organization.

::: (Info) (NOTE:)
If you previously have configured your npm feed to use an npm audit proxy and want to use ProGet's vulnerability details instead, you will need to change the `npm audit` settings on your feed's Manage Feed page.
:::

You can also use ProGet's [Policies & Compliance Rules](https://docs.inedo.com/docs/proget/sca/policies) to define rules about licensing, vulnerability, deprecation, etc. This will let you block download or usage of any packages you have defined as "noncompliant".

#### Prior to ProGet 2023.22

Npm Audit Proxying is an experimental feature. ProGet may attempt to forward requests to the audit endpoint to npmjs.org or a connector. This may stop working if `npmjs.org` changes the API or blocks ProGet's requests. You can configure the proxy URL in ProGet 5.3 by navigating to the "Manage Feed" page on your npm feed.

## Creating and Publishing Your Own Packages 

You can also create and publish packages to ProGet using npm. First, you will need to [authenticate to your npm feed](#authenticate-feed) using an account or an API key that has the "Add Package" permission, then run the `npm publish` command:

```bash
$ npm publish package.tgz
```

Or run `yarn publish` if using Yarn:

```bash
$ yarn publish package.tgz
```

This command will publish `package.tgz` to your npm feed in ProGet. For a more detailed guide on creating and publishing your own npm packages you can read [HOWTO: Publish npm Packages to a Private Registry in ProGet](/docs/proget/feeds/npm/howto-npm-publish)

## Versioning in ProGet and npmjs.org

ProGet npm feeds fully support [Semantic Versioning (SemVer2)](https://docs.npmjs.com/about-semantic-versioning), including build metadata (the `+` symbol in version numbers). However, when using a connector to [npmjs.org](https://www.npmjs.org), you may encounter inconsistencies with how build metadata is handled.

### Build Metadata and npmjs.org

While npmjs.org claims to support SemVer2, build metadata isn't always visible in queries made to their registry. This can cause unexpected behavior when using ProGet with an `npmjs.org` connector. For instance, certain versions of packages  —such as [@hot-loader/react-dom](https://www.npmjs.com/package/@hot-loader/react-dom) not be found by the npm client, even though they exist.

This issue seems to affect a very small number of packages. If it becomes more problematic, we may consider adjustments, but we encourage users to contribute to the ongoing discussion at [NPM Connector returns plus "+" in versions](https://forums.inedo.com/topic/2948) in our community forum.

## Troubleshooting

### Error: Unable to query https://npm.pkg.github.com/

GitHub npm connectors work a bit differently than other connectors.  GitHub does not implement the full npm API specification so certain things like package count and the search API are not working.  To get around this in ProGet, you will need to make sure that you have updated to at least ProGet 2023.20 and then use the following settings:

1. On the *General* tab
   1. For the URL use `https://npm.pkg.github.com/<OWNER>`
   2. For Authentication
      1. Use Basic authentication
      2. For the username, use your GitHub username
      3. For the password, use your  and then use a Personal Access Token (classic)
1. On the *Advanced* tab
   1. Check "Exact package name match only" 
   2. Check "Do not perform health check" 

That should allow you to search for the package by the exact package name and allow your npm applications to pull the packages properly.  

::: (Info)
Please note that partial name searches may not return any values from your GitHub connector since GitHub has not implemented the search API.
:::

### Error: Unable to Disable Windows Integrated Authentication

The npm client does not support the use of Windows Integrated Authentication, so ProGet attempts to disable its use for npm API endpoints in favor of basic HTTP authentication. However, disabling Windows Authentication on a URL basis does not work in every environment. If you have trouble getting this to work, you can create a second website in IIS for ProGet with Windows Authentication disabled without purchasing a separate license.