---
title: "BuildMaster Release & Build Deployment API"
order: 9
---

The Release & Build Deployment API offers a simple mechanism for creating releases, creating builds, and deploying builds.

This endpoint receives data entirely as key/value parameters, which may be specified in both the querystring _and_ body (`application/x-www-form-urlencoded`); duplicate keys will result in a failed request (400 status).

All API endpoints are accessed through the following base URL:

:::(info)
 `/api/releases/...`
:::

<h3 id="releases-endpoints">🚀 Releases Endpoints</h3>

[Create Release](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-releases-create) - Creates a release
[Get Releases](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-releases-get) - Returns a list of all releases
[Restore Release](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-releases-restore) - Restores a release
[Cancel Release](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-releases-cancel) - Cancels a release

<h3 id="builds-endpoints">🛠 Builds Endpoints</h3>

[Create Build](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-builds-create) - Creates a build
[Deploy Build](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-builds-deploy) - Deploys a build
[Get Build](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-builds-get) - Returns a list of all builds
[Reject Build](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-builds-reject) - Rejects a build

<h3 id="deployments-endpoints"> ⚙ Deployments Endpoint</h3>

[Get Deployments](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-deployments-get) - Returns a list of all deployments

<h2 id="authentication">Authentication</h2>

An API Key with the Release & Build Deployment permission is required to use this API.

It can be passed to each endpoint in one of four ways, depending on the content type of the expected request:

| Method | Name or Key | Details |
|----|----|----|
|Request header| `X-ApiKey` | *all content types* |
|Querystring value| `key` | *all content types* |
|Form value| `key` | only `applications/x-www-form-urlencoded` content type |
|JSON property | `API_Key` | on root object, only `application/json` content type |

To specify an API Key, use the request header (`X-ApiKey`), querystring (`key`), or `api:«api-key»` as the user name. See [API Access and API Key](/docs/buildmaster/reference/api/buildmaster-administration-security-api-keys) to learn more.

::: (info) (🚀 Quick Example: Authenticating with curl)
For example, to authenticate with the API key `a1b2c3d4e5` to the create build endpoint, you could specify the API key as follows:
````
curl -X POST -H "X-ApiKey: a1b2c3d4e5" "/api/releases/builds/create"
````
If the provided API key is either missing, unknown/incorrect or does not have permission, the following message is returned:
````
The specified API key does not have the proper permissions to perform this action.
````
:::

## Data Specifications
::: (info) (📄 Note: PipelineId)
In BuildMaster 6.1 and earlier, these data objects contained a `pipelineId` which was an _integer_ identifier for the pipeline used by the release. However, since BuildMaster 6.2, pipelines are stored in raft repositories (which can be a zip file or a git repository) and therefore no longer have a native identifier.
:::

<h3 id="releaseinfo-object">ReleaseInfo Object Properties</h3>

`ReleaseInfo` is a set of key/value pairs that correspond to the fields on a Release. It's used as output data for the [Create Release](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-releases-create) and [Get Releases](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-releases-get) endpoints, returning `ReleaseInfo` as a JSON-formatted object.

| Property | Format |
| --- | --- |
| `id` | An _integer_ representing the system-unique identifier of the release. |
| `releaseNumber` | A _string_ representing the application-unique identifier of the release. |
| `releaseName` | A _string_ representing the non-unique name or alias for the release. |
| `sequence` | An _integer_ representing the sequence relative to other releases in the application. |
| `template` | A _string_ of the template name used for this release, or `null` if no template is used. |
| `status` | A _string_ consisting of `active`, `deployed`, or `canceled`. |
| `createdBy` | A _string_ representing the user who created the release, or `SYSTEM` if created non-interactively. |
| `createdOn` | A _string_ representing the UTC date when the release was created, in ISO 8601 format (yyyy-MM-ddThh:mm:ss). |
| `canceledBy` | A _string_ representing the user who canceled the release, or `SYSTEM` if created non-interactively. |
| `canceledOn` | A _string_ representing the UTC date when the release was created, in ISO 8601 format (yyyy-MM-ddThh:mm:ss). |
| `targetDate` | A _string_ representing the UTC date of the target release date in ISO 8601 format (yyyy-MM-ddThh:mm:ss). |
| `applicationId` | An _integer_ representing the system-unique identifier of the application for the release. |
| `applicationName` | A _string_ representing the system-unique name of the application for the release. |
| `pipelineName` | A _string_ representing the name of the pipeline used by the release. |
| `furthestBuildId` | An _integer_ representing the system-unique identifier of the active or deployed build that has made it furthest in the pipeline for the release. |
| `furthestBuildNumber` | A _string_ representing the application-unique number of the active or deployed build that has made it furthest in the pipeline for the release. |
| `latestBuildId` | An _integer_ representing the system-unique identifier of the active or deployed build that was most recently created. |
| `latestBuildNumber` | A _string_ representing the application-unique number of the active or deployed build that was most recently created. |

#### JSON Object
```json
{
    "id": 1,
    "number": "1.0.1",
    "name": "1.0.1",
    "sequence": 1,
    "status": "active",
    "createdBy": "MikeJones",
    "createdOn": "2024-03-04T09:03:43.9200000Z",
    "applicationId": 1,
    "applicationName": "ProfitCalculator",
    "pipelineName": "Release",
    "furthestBuildId": 3,
    "furthestBuildNumber": "2",
    "latestBuildId": 3,
    "latestBuildNumber": "2",
    "deployables": [],
    "furthestPackageId": 3,
    "furthestPackageNumber": "2",
    "latestPackageId": 3,
    "latestPackageNumber": "2",
    "releaseName": "1.0.1",
    "releaseNumber": "1.0.1"
}
```

<h3 id="buildinfo-object">BuildInfo Object Properties</h3>

`BuildInfo` is a set of key/value pairs that correspond to the fields on a Build. It's used as output data for the [Create Build](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-builds-create) and [Get Build](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-builds-get) endpoints, returning `BuildInfo` as a JSON-formatted object.

| Property | Format |
| --- | --- |
| `id` | An _integer_ representing the system-unique identifier of the build. |
| `buildNumber` | A _string_ representing the build-unique identifier of the build. |
| `status` | A _string_ consisting of `active`, `deployed`, or `rejected`. |
| `createdBy` | A _string_ representing the user who created the build, or `SYSTEM` if created non-interactively. |
| `createdOn` | A _string_ representing the UTC date when the build was created, in ISO 8601 format (yyyy-MM-ddThh:mm:ss). |
| `rejectedBy` | A _string_ representing the user who rejected the build, or `SYSTEM` if rejected non-interactively. |
| `rejectedOn` | A _string_ representing the UTC date when the build was rejected, in ISO 8601 format (yyyy-MM-ddThh:mm:ss). |
| `pipelineName` | A _string_ representing the name of the pipeline used by the build. |
| `furthestStage` | A _string_ representing the name of the furthest stage the build has advanced to in the pipeline. |
| `applicationId` | An _integer_ representing the system-unique identifier of the application for the build. |
| `applicationName` | A _string_ representing the system-unique name of the application for the build. |
| `releaseId` | An _integer_ representing the system-unique identifier of the release for the build. |
| `releaseNumber` | A _string_ representing the application-unique number of the release for the build. |
| `releaseName` | A _string_ representing the name of the release for the build. |

#### JSON Object
```json
{
    "id": 1,
    "number": "3",
    "status": "active",
    "createdBy": "API",
    "createdOn": "2024-03-05T02:46:56.0800000Z",
    "applicationId": 2,
    "applicationName": "TaxCalculator",
    "pipelineName": "Release",
    "releaseId": 4,
    "releaseNumber": "1.0.1",
    "releaseName": "1.0.1",
    "buildNumber": "3"
}
```

<h3 id="deploymentinfo-object">DeploymentInfo Object Properties</h3>

`DeploymentInfo` is a set of key/value pairs that correspond to the fields on a Release. It's used as both input and output data for the [Deploy Build](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-builds-deploy) and [Get Deployments](/docs/buildmaster/reference/api/release-and-build/buildmaster-buildrelease-deployments-get) endpoints, returning `DeploymentInfo` as a JSON-formatted object.

| Property | Format |
| --- | --- |
| `id` | An _integer_ representing the system-unique identifier of the deployment. |
| `plan` | A _string_ representing the name of the plan used for deployment. |
| `status` | A _string_ consisting of `pending`, `executing`, `succeeded`, `warned`, or `failed`.|
| `started` | A _string_ representing the UTC date when the deployment actually started, in ISO 8601 format (yyyy-MM-ddThh:mm:ss), or null if the execution hasn't started. |
| `ended` | A _string_ representing the UTC date when the deployment completed, in ISO 8601 format (yyyy-MM-ddThh:mm:ss), or null if the execution hasn't completed. |
| `createdBy` | A _string_ representing the user who initiated the deployment, or `SYSTEM` if initiated non-interactively. |
| `createdOn` | A _string_ representing the UTC date when the deployment was initiated, in ISO 8601 format (yyyy-MM-ddThh:mm:ss). |
| `canceledBy` | A _string_ representing the user who canceled the deployment (`SYSTEM` if canceled non-interactively), or null if the deployment was not canceled. |
| `canceledOn` | A _string_ representing the UTC date when the deployment was canceled, in ISO 8601 format (yyyy-MM-ddThh:mm:ss), or null if the deployment was not canceled. |
| `pipelineName` | A _string_ representing the name of the pipeline used by the deployment. |
| `pipelineStageName` | A _string_ representing the name of the stage in the pipeline used by the deployment. |
| `environmentId` | An _integer_ representing the system-unique identifier of the environment used by the deployment, or null if no environment is in context. |
| `environmentName` | A _string_ representing the name of the environment used by the deployment, or null if no environment is in context. |
| `applicationId` | An _integer_ representing the system-unique identifier of the application for the deployment. |
| `applicationName` | A _string_ representing the system-unique name of the application for the deployment. |
| `releaseId` | An _integer_ representing the system-unique identifier of the release for the deployment. |
| `releaseNumber` | A _string_ representing the application-unique number of the release for the deployment. |
| `releaseName` | A _string_ representing the name of the release for the deployment. |
| `buildId` | An _integer_ representing the system-unique identifier of the build for the deployment. |
| `buildNumber` | A _string_ representing the release-unique number of the build for the deployment. |

```json
{
    "id": 1,
    "plan": "Deploy",
    "status": "succeeded",
    "started": "2024-03-04T09:31:20.5100000Z",
    "ended": "2024-03-04T09:31:20.6100000Z",
    "createdBy": "SYSTEM",
    "createdOn": "2024-03-04T09:31:15.4900000Z",
    "pipelineName": "Release",
    "pipelineStageName": "Integration",
    "applicationId": 1,
    "applicationName": "TaxCalculator",
    "releaseId": 1,
    "releaseNumber": "1.0.1",
    "releaseName": "1.0.1",
    "buildId": 1,
    "buildNumber": "2",
    "packageId": 1,
    "packageNumber": "2"
}
```