---
title: Static Application Security Testing (SAST)
breadcrumb: SAST
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Static Application Security Testing (SAST)

## Definition

**Static Application Security Testing (SAST)** is a type of security testing that examines the source code of an application to identify vulnerabilities and security flaws without executing the code. SAST is an essential part of the DevSecOps process, as it enables early detection of security issues during the development phase, thus reducing the risk of vulnerabilities in the released software.

## Related Terms

- **Dynamic Application Security Testing (DAST):** Testing methodology that identifies security vulnerabilities in a running application.
- **Software Development Lifecycle (SDLC):** The process used for planning, creating, testing, and deploying an information system.
- **Vulnerability Assessment:** The process of identifying, quantifying, and prioritizing vulnerabilities in a system.
- **Code Review:** The systematic examination of computer source code intended to find and fix mistakes overlooked in the initial development phase.

## Components of SAST

1. **Source Code Analysis:** Examining the application's source code for coding errors or security lapses.
2. **Configuration Analysis:** Assessing configurations and settings within the application code for potential vulnerabilities.
3. **Data Flow Analysis:** Evaluating the flow of data through the application to identify points where data may be compromised.

## Example

An example of implementing SAST:

- **Scenario:** A development team is working on a new financial software application.
- **SAST Implementation:**
    - Before integrating new code into the main branch, the team uses a SAST tool to scan the source code.
    - The SAST tool identifies potential security issues, such as SQL injection vulnerabilities or insecure data storage practices.
    - The team addresses these issues in the development phase, well before the application is deployed or reaches the testing phase.
- **Outcome:** By integrating SAST into their development process, the team significantly reduces the risk of security vulnerabilities in the final product, ensuring a more secure and robust application.

In this scenario, SAST is a proactive measure in the DevSecOps pipeline, crucial for identifying and mitigating security risks early in the software development lifecycle.
