---
title: Penetration Testing
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Penetration Testing

## Definition

**Penetration Testing**, often referred to as 'pen testing' or 'ethical hacking,' is the practice of testing a computer system, network, or web application to find vulnerabilities that an attacker could exploit. In the context of DevSecOps, penetration testing is a proactive approach to uncovering system vulnerabilities and ensuring that security measures are effective.

## Related Terms

- **Vulnerability Assessment:** The process of identifying, quantifying, and prioritizing (or ranking) the vulnerabilities in a system.
- **Ethical Hacking:** An authorized practice of bypassing system security to identify potential data breaches and threats in a network.
- **Red Team:** A group that plays the role of an adversary in a simulated cyberattack.
- **Blue Team:** The defenders who try to protect the organization's assets against red teams or real attackers.

## Types of Penetration Testing

1. **Network Services Test:** Evaluates the weaknesses in the network infrastructure (hardware).
2. **Web Application Test:** Focuses on identifying vulnerabilities in web-based applications (software).
3. **Client-Side Test:** Identifies security threats in client-side applications like browsers and document editors.
4. **Wireless Network Test:** Checks for vulnerabilities in wireless networks, such as Wi-Fi and Bluetooth.
5. **Social Engineering Test:** Involves attempts to obtain sensitive information from personnel through manipulation techniques.

## Example

An example of a penetration testing scenario:

- **Scenario:** A financial institution wants to assess the security of its online banking platform.
- **Penetration Testing Implementation:**
    - The institution hires a team of ethical hackers to perform a penetration test on the platform.
    - The team conducts a series of tests, including attempting to breach the application’s defenses to access sensitive data.
    - They use various techniques, from network attacks to social engineering, to evaluate the system's security.
- **Outcome:** The test identifies several vulnerabilities which are then addressed, significantly improving the security of the online banking platform.

In this scenario, penetration testing is an essential component of the institution’s security strategy, providing insights into potential vulnerabilities and helping to fortify the platform against actual cyber attacks.
