---
title: Intrusion Prevention Systems (IPS)
breadcrumb: IPS
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Intrusion Prevention Systems (IPS)

## Definition

**Intrusion Prevention Systems (IPS)** are network security tools designed to recognize and respond to potential threats in real-time. Unlike Intrusion Detection Systems (IDS) which only detect and alert, IPS systems actively prevent or block the identified threats. IPS plays a crucial role in the DevSecOps environment by providing automated protection against attacks that could compromise system integrity and data security.

## Related Terms

- **Intrusion Detection Systems (IDS):** Systems that monitor network or system activities for malicious actions or policy violations and report them.
- **Firewall:** A network security system that monitors and controls incoming and outgoing network traffic based on predetermined security rules.
- **Network Security:** The practice of preventing and protecting against unauthorized intrusion into corporate networks.
- **Threat Intelligence:** The knowledge used to understand and identify potential security threats.

## Types of Intrusion Prevention Systems

1. **Network-Based IPS (NIPS):** Monitors the entire network for suspicious traffic and malicious activity.
2. **Wireless IPS (WIPS):** Specifically designed to monitor and protect a wireless network from unauthorized access or damage.
3. **Host-Based IPS (HIPS):** Installed on individual devices and monitors them for suspicious activity.
4. **Signature-Based IPS:** Detects attacks by looking for specific patterns or signatures in the traffic.
5. **Anomaly-Based IPS:** Identifies unusual patterns or behaviors that could indicate a network or system security breach.

## Example

An example of deploying an IPS:

- **Scenario:** An online retail company wants to enhance its network security.
- **IPS Implementation:**
    - They implement a network-based IPS to continuously monitor their network traffic.
    - The IPS is configured with the latest threat intelligence to recognize and block known attack patterns.
    - It also uses anomaly-based detection to identify and mitigate new or unknown types of attacks.
    - The system is integrated into the existing network infrastructure without disrupting normal business operations.
- **Outcome:** The IPS provides proactive security, protecting the company’s network from a wide range of threats, thereby ensuring the safety and privacy of customer data and maintaining business continuity.

In this scenario, the IPS is a vital security measure, offering comprehensive protection against both known and emerging network threats, essential for maintaining robust network security in a dynamic online business environment.
