---
title: Shift-left
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Shift-left

## Definition

**Shift-left** is a practice in software development, particularly in DevSecOps, that emphasizes the integration of security and testing measures early in the software development lifecycle (SDLC). The goal is to identify and address security issues, bugs, and vulnerabilities at the earliest stages, rather than in later phases or after deployment, thereby reducing risk and improving efficiency.

## Related Terms

- **DevSecOps:** An approach that integrates security practices within the DevOps process.
- **Continuous Integration/Continuous Deployment (CI/CD):** A method to frequently deliver apps to customers by introducing automation into the stages of app development.
- **Automated Testing:** Using automated tools to execute tests on the software to ensure quality and functionality.
- **Code Review:** The systematic examination of computer source code intended to find and fix mistakes overlooked in the initial development phase.

## Types of Shift-left Practices


1. **Package Approval Workflow:** Vet unwanted pacakges using tools like ProGet before unwated packages get in hands of developers.  
2. **Code Analysis:** Performing static and dynamic code analysis to detect vulnerabilities as soon as code is written.
3. **Requirements Analysis:** Integrating security considerations during the requirements gathering and design phases.
4. **Developer Training:** Educating developers on secure coding practices and awareness of common security pitfalls.
5. **Automated Security Testing:** Incorporating automated security testing tools in the early stages of development.

## Example

An example of implementing shift-left:

- **Scenario:** A software company develops a new web application.
- **Shift-left Implementation:**
    - The company integrates security testing tools into their CI/CD pipeline, allowing for automatic security scans with each code commit.
    - Developers receive training on secure coding practices and are encouraged to perform code reviews with a focus on security.
    - Security considerations are included in the planning phase of each feature or update.
- **Outcome:** By shifting security left, the company identifies and mitigates security issues much earlier, reducing the number of vulnerabilities in the production environment and improving the overall security posture of their application.

In this scenario, shift-left practices enable the software company to proactively manage security risks, leading to more secure and reliable software development outcomes.
