---
title: Role-Based Access Control (RBAC)
breadcrumb: RBAC
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Role-Based Access Control (RBAC)

## Definition

**Role-Based Access Control (RBAC)** is a method of restricting system access to authorized users based on their role within an organization. It is a fundamental concept in DevSecOps where access to systems, networks, and data is given based on the user's role, providing a more streamlined and secure approach to access management. RBAC helps in minimizing the potential for unauthorized access and simplifying the process of granting appropriate access to users.

## Related Terms

- **Access Control:** The selective restriction of access to a place or other resource.
- **Principle of Least Privilege:** The practice of limiting access rights for users to the bare minimum permissions they need to perform their work.
- **Authentication:** The process of verifying the identity of a user or process.
- **Authorization:** The process of granting or denying specific permissions to a user, group, or role.

## Types of RBAC

1. **Core RBAC:** A standard model where access is based on roles and roles are assigned to users.
2. **Hierarchical RBAC:** Roles inherit permissions from other roles in a hierarchy.
3. **Constrained RBAC:** Adds constraints or conditions to role assignments or permissions (like time-of-day restrictions).
4. **Attributed RBAC:** Roles are assigned based on attributes (like department, job title, etc.) in addition to the role name.

## Example

An example of RBAC implementation:

- **Scenario:** A company wants to secure its internal systems.
- **RBAC Implementation:**
    - They define roles like 'Administrator', 'Manager', 'HR', and 'Employee' with different access levels.
    - Users are assigned to these roles based on their job functions.
    - Each role has specific permissions, ensuring users can only access information necessary for their role.
    - For example, only HR personnel can access employee records, while employees have limited access to general resources.
- **Outcome:** This RBAC setup ensures that users have appropriate access levels, reducing the risk of sensitive information being accessed by unauthorized users.

In this scenario, RBAC is crucial for maintaining a secure and efficient access control system within the organization, ensuring users have the necessary permissions aligned with their roles and responsibilities.
