---
title: Infrastructure as Code (IaC)
breadcrumb: IaC
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Infrastructure as Code (IaC)

## Definition

**Infrastructure as Code (IaC)** is a key DevSecOps practice that involves managing and provisioning computing infrastructure through machine-readable definition files, rather than physical hardware configuration or interactive configuration tools. IaC enables IT infrastructure to be managed in a manner similar to how software is managed, making the process more efficient, consistent, and repeatable.

## Related Terms

- **Configuration Management:** The process of standardizing resource configurations and enforcing their state across the IT infrastructure in an automated manner.
- **Provisioning:** The process of setting up IT infrastructure to make it available for use.
- **Continuous Deployment:** The practice of automatically deploying into production new releases that pass all stages of the production pipeline.
- **Version Control:** The management of changes to documents, computer programs, large web sites, and other collections of information.

## Types of IaC

1. **Declarative Approach (Functional):** Specifies the desired state of the infrastructure without explicitly listing the steps to achieve it (e.g., Terraform, CloudFormation).
2. **Imperative Approach (Procedural):** Specifies commands that must be executed in the correct order to achieve the desired state (e.g., Chef, Puppet).
3. **Hybrid Approach:** Combines both declarative and imperative approaches.

## Example

An example of Infrastructure as Code:

- **Scenario:** A company needs to deploy and manage a multi-tier web application.
- **IaC Implementation:**
    - They use a tool like Terraform to define the infrastructure for their application in code.
    - This code specifies the necessary components such as virtual machines, networks, and storage.
    - When the code is executed, Terraform automatically creates the environment as described.
    - Any changes to the infrastructure are made through changes to the code and reapplying it.
- **Outcome:** This approach allows the company to quickly set up, modify, and replicate their infrastructure with minimal manual intervention, ensuring consistency and reducing errors.

In this scenario, IaC provides an efficient, reliable, and repeatable method for managing infrastructure, which is crucial in a dynamic DevSecOps environment.
