---
title: High Availability
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# High Availability

## Definition

**High Availability (HA)** in the context of DevSecOps refers to systems and processes designed to ensure operational continuity and minimize downtime in the event of failures. High Availability involves the implementation of redundant components and failover mechanisms to provide seamless, continuous service, even during system outages or maintenance.

## Related Terms

- **Fault Tolerance:** The ability of a system to continue operating properly in the event of the failure of some of its components.
- **Redundancy:** The duplication of critical components or functions of a system with the intention of increasing reliability.
- **Load Balancing:** The process of distributing network or application traffic across multiple servers to ensure no single server bears too much demand.
- **Failover:** The automatic switching to a redundant or standby system upon the failure or abnormal termination of the currently active system.

## Types of High Availability

1. **Active-Active:** All systems are running simultaneously in a load-balanced environment. In case of a failure, traffic is rerouted to the remaining operational systems.
2. **Active-Passive:** A primary system is active, while a secondary system is in standby mode, ready to take over in case the primary fails.
3. **Active-Active-Passive:** Combines both methods, where two systems are active and a third is in standby to provide additional backup.

## Example

Consider an online banking application that requires high availability:

- **High Availability Implementation:**
    1. The application is deployed across multiple data centers (Active-Active model).
    2. Load balancers distribute the traffic evenly across these centers.
    3. In case one data center fails, the load balancer automatically redirects traffic to the remaining centers without interrupting user service.
    4. Regular testing is conducted to ensure seamless failover.
- **Outcome:** This setup ensures that the banking application remains available and functional, even if one of the data centers experiences an outage, thereby maintaining a high level of service and trust with users.

In this scenario, High Availability is critical to ensure that the banking services are always accessible to users, reflecting the importance of HA in maintaining business operations and customer satisfaction.
