---
title: Dynamic Application Security Testing (DAST)
breadcrumb: DAST
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Dynamic Application Security Testing (DAST)

## Definition

**Dynamic Application Security Testing (DAST)** is a process that identifies security vulnerabilities in applications by testing them in a running state. This method is used in DevSecOps to detect issues like cross-site scripting, SQL injection, and other vulnerabilities that are exploitable in a live application.

## Related Terms

- **Static Application Security Testing (SAST):** A testing methodology that examines source code for security vulnerabilities without executing the application.
- **Penetration Testing:** Simulating cyberattacks on a computer system to evaluate the security of the system.
- **Security Testing:** The process of identifying and remedying vulnerabilities in software.
- **Vulnerability Assessment:** The process of identifying, quantifying, and prioritizing the vulnerabilities in a system.

## Types of DAST

1. **Black Box Testing:** Testing an application without knowledge of its internal workings, simulating an external hacking attack.
2. **Grey Box Testing:** Partial knowledge of the application's internal workings is used to conduct the test.
3. **Automated Scanning:** Using automated tools to scan a running application to identify vulnerabilities.

## Example

An example of a DAST scenario could be:

- **Context:** A company has developed a web application that handles sensitive user data.
- **DAST Implementation:**
    - The application is deployed in a testing environment.
    - A DAST tool like OWASP ZAP or Acunetix is used to scan the application while it is running.
    - The tool automatically tests for common vulnerabilities and provides a report of potential security issues.
- **Outcome:** The development team uses the report to identify and rectify security flaws before the application is deployed in a production environment.

In this example, DAST is an essential part of the security testing lifecycle, helping to ensure that the web application is secure against real-world attack scenarios before it goes live.
