---
title: CSRF (Cross-Site Request Forgery)
breadcrumb: CSRF
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# CSRF (Cross-Site Request Forgery)

## Definition

**Cross-Site Request Forgery (CSRF)** is a type of web security vulnerability that tricks a user's web browser into performing unwanted actions on a web application where they are authenticated. In a CSRF attack, unsuspecting users are typically deceived into submitting a malicious request, such as transferring funds or changing an email address, unknowingly.

## Related Terms

- **Session Handling:** The process of managing user sessions in a web application, which is often targeted in CSRF attacks.
- **Token-based Authentication:** A security technique where a token is used to authenticate and authorize users, helping to prevent CSRF attacks.
- **Same-Origin Policy (SOP):** A security concept in web development that restricts how documents or scripts loaded from one origin can interact with resources from another origin.
- **Anti-CSRF Tokens:** Unique tokens generated by a server and used to validate user requests, helping to prevent CSRF.

## Types of CSRF Attacks

1. **Simple CSRF:** Directly involves a victim who is tricked into clicking a link or loading an image that results in an unwanted request.
2. **Token-Based CSRF:** Bypasses simple anti-CSRF measures by exploiting sites that don’t properly check for CSRF tokens or have predictable token generation.
3. **Double Submit Cookie:** A variation where cookies are used for CSRF protection, but can be exploited if not implemented correctly.

## Example

A common CSRF scenario:

- **Scenario:** A user is logged into their bank's website, which is vulnerable to CSRF.
- **Attack:** The user visits another site where a malicious script or image is hosted.
- **Execution:** The script or image makes a request to the bank's site (like a fund transfer) using the user's authentication from the other site.
- **Impact:** The bank processes the request as if it was intentionally made by the user, resulting in unauthorized transactions.

In this case, using anti-CSRF tokens and ensuring that each session and action requires unique token verification can mitigate the risk of CSRF attacks.
