---
title: Cross-Site Scripting (XSS)
breadcrumb: XSS
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Cross-Site Scripting (XSS)

## Definition

**Cross-Site Scripting (XSS)** is a type of security vulnerability typically found in web applications. XSS enables attackers to inject client-side scripts into web pages viewed by other users. This vulnerability can be used by attackers to bypass access controls and steal information, impersonate users, or perform actions on behalf of users.

## Related Terms

- **Client-Side Scripting:** Programming that is executed by the browser on the client side, typically using languages like JavaScript.
- **Web Application Security:** Measures and protocols used to protect web applications from threats such as XSS.
- **Input Sanitization:** The process of cleaning and validating user input to prevent vulnerabilities, including XSS.
- **Session Hijacking:** A form of attack where an attacker takes control of a user's session to gain unauthorized access to information or services.

## Types of XSS

1. **Stored XSS (Persistent XSS):** The malicious script is stored on the target server, such as in a database, and is then reflected to subsequent users.
2. **Reflected XSS (Non-Persistent XSS):** The malicious script is reflected off a web server, such as in an error message or search result.
3. **DOM-Based XSS:** The vulnerability exists in the client-side script itself and is triggered when the page's Document Object Model (DOM) changes.

## Example

An example of a Reflected XSS attack:

- **Scenario:** A user visits a web application that includes a search function.
- **Attack:** The attacker tricks the user into clicking a link that includes a malicious script in the URL.
- **Execution:** When the user's browser processes the URL, the script executes within the context of the user's session.
- **Impact:** The script could, for example, send the user's session cookie to the attacker, allowing them to impersonate the user.

In this example, proper input validation and encoding on the server-side could prevent the script from being executed, thereby mitigating the XSS risk.
