---
title: Continuous Integration (CI)
breadcrumb: CI
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Continuous Integration (CI)

## Definition

**Continuous Integration (CI)** is a DevSecOps practice where developers frequently merge their code changes into a central repository, after which automated builds and tests are run. The primary goals of CI are to find and address bugs quicker, improve software quality, and reduce the time it takes to validate and release new software updates.

## Related Terms

- **Continuous Deployment (CD):** An extension of CI where all code changes are automatically deployed to a production environment after the build and test stages.
- **DevOps:** A set of practices that combines software development (Dev) and IT operations (Ops), emphasizing collaboration, automation, and continuous delivery.
- **Automated Testing:** Running tests automatically to ensure software quality and functionality after changes are made.
- **Build Automation:** The process of automating the creation of a software build and the associated processes including compiling computer source code into binary code.

## Types of Continuous Integration

1. **Feature Branch Workflow:** Integrating code changes by merging feature branches into the main branch frequently.
2. **Forking Workflow:** Each developer has two repositories: a private local one and a public server-side one, ensuring CI runs on both repositories.
3. **Trunk-Based Development:** Developers work on a single branch (the "trunk"), with short-lived feature branches, integrating changes frequently.

## Example

Consider a team developing a mobile application:

- **CI Process:**
    1. A developer commits code to a feature branch in the shared repository.
    2. On commit, an automated CI service (like Jenkins, Travis CI, or CircleCI) is triggered.
    3. The CI service automatically builds the project and runs a suite of automated tests.
    4. If the build and tests pass, the branch is eligible to be merged into the main branch.
- **Benefit:** This ensures that the main branch is always in a deployable state, bugs are detected early, and the codebase remains stable, facilitating more frequent releases.

Through this CI process, the team can maintain a high standard of code quality and streamline the development workflow, resulting in efficient and reliable software delivery.
