---
title: Dependency Scanning
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Dependency Scanning

## Definition

**Dependency Scanning** is a practice in DevSecOps that involves examining software dependencies (libraries, packages, modules) for known security vulnerabilities. By identifying and addressing these vulnerabilities early in the development lifecycle, dependency scanning helps maintain the security and integrity of an application.

## Related Terms

- **Software Composition Analysis (SCA):** A process that identifies third-party and open-source components in code to manage the risk associated with using these components.
- **Vulnerability Database:** A database that contains information about identified security vulnerabilities in software.
- **Package Manager:** A tool that automates the process of installing, upgrading, configuring, or removing software packages in a consistent manner.
- **DevSecOps:** An approach that integrates security practices within the DevOps process.

## Types of Dependency Scanning

1. **Static Scanning:** Analyzing the dependencies without executing the code or the application.
2. **Dynamic Scanning:** Running the application in a controlled environment to monitor the behavior of dependencies.
3. **License Compliance Scanning:** Checking dependencies for license compliance issues.

## Example

Consider a scenario where a development team is working on a web application using several open-source libraries:

- **Dependency Scanning Process:**
    1. The team uses a tool like SonarQube, Snyk, or OWASP Dependency-Check.
    2. The tool scans the project's dependencies against a vulnerability database.
    3. It identifies any libraries with known vulnerabilities, such as outdated versions or security flaws.
    4. The team is then able to update or replace vulnerable dependencies before deploying the application.
- **Benefit:** This process ensures that the application is not compromised by vulnerabilities in its dependencies, thereby reducing the risk of security breaches and maintaining the integrity of the application.

Dependency scanning in this scenario is an integral part of maintaining the security posture of the application throughout its development lifecycle.
