---
title: Continuous Deployment (CD)
breadcrumb: CD
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Continuous Deployment (CD)

## Definition

**Continuous Deployment (CD)** is a software engineering approach in which software is automatically released to production after passing through the stages of the development pipeline. This practice is a key part of the DevSecOps methodology, aiming to reduce manual tasks, minimize errors, and accelerate the delivery of software updates to users.

## Related Terms

- **Continuous Integration (CI):** A practice in software engineering where all code changes are automatically built, tested, and merged into a shared repository frequently.
- **DevOps:** A set of practices that combines software development (Dev) and IT operations (Ops) aiming to shorten the systems development life cycle and provide continuous delivery with high software quality.
- **Continuous Delivery:** An extension of continuous integration, where the software can be released to production at any time, with the approval of a human gatekeeper.
- **Automation:** The use of technology to perform tasks with reduced human intervention.

## Types of Continuous Deployment

1. **Automated Testing:** Automatically running a suite of tests on new software changes to ensure they meet quality standards before deployment.
2. **Environment-Based CD:** Deploying code to different environments (development, testing, staging, production) in sequence or in parallel, depending on the workflow.
3. **Feature Flag-Based CD:** Deploying new features into production but hiding them behind feature flags, allowing selective enabling for different user segments.

