---
title: Compliance as Code
parent_breadcrumbs:
  - title: Security Keywords
    url: keywords
---

# Compliance as Code

## Definition

**Compliance as Code** is a modern approach in DevSecOps that involves defining and managing regulatory and security compliance in a programmable and automated way. This approach allows organizations to embed compliance and security standards directly into the development, deployment, and operation of IT systems, ensuring continuous compliance and reducing manual oversight.

## Related Terms

- **Infrastructure as Code (IaC):** The process of managing and provisioning infrastructure through machine-readable definition files, rather than physical hardware configuration.
- **Policy as Code:** The practice of managing and automating policy enforcement through code.
- **Security as Code:** Integrating security practices into the codebase to automate security checks and controls.
- **DevSecOps:** A culture and practice that integrates security practices within the DevOps process.

## Types of Compliance as Code

1. **Regulatory Compliance as Code:** Automating the enforcement of laws and regulations, such as GDPR or HIPAA, within IT systems.
2. **Security Standards Compliance as Code:** Embedding security standards like ISO 27001 or NIST frameworks into system configurations and deployments.
3. **Organizational Policy Compliance as Code:** Automating the enforcement of internal policies and best practices within IT operations.